using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using System.Web.Security;

namespace CoilCenter3FZ.DetailDelivery
{
	/// <summary>
	/// Summary description for DDSREPORT.
	/// </summary>
	public class DDSREPORT : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.HyperLink HyperLink1;
		protected System.Web.UI.WebControls.HyperLink Print_Lnk;
		protected System.Web.UI.WebControls.Button Button2;
		protected System.Web.UI.WebControls.Button Logout_Btn;
		protected System.Web.UI.WebControls.Label WarningLbl;
		protected System.Web.UI.HtmlControls.HtmlInputHidden ScrollPOS;
		protected System.Data.SqlClient.SqlConnection sqlconn;
		protected System.Web.UI.HtmlControls.HtmlInputHidden HidWarning;
		protected System.Web.UI.WebControls.Button View1Btn;
		protected System.Web.UI.WebControls.Button View2Btn;
		protected System.Web.UI.WebControls.Button View3Btn;
		protected System.Web.UI.WebControls.TextBox Cust3Tbx;
		protected System.Web.UI.WebControls.DropDownList TripDdl;

		//Define Use Class Here
		private MSSQL_Function MSSQL_Function = new MSSQL_Function();
		private GUI_Function GUI_Function = new GUI_Function();
		private Utility_Function Utility_Function = new Utility_Function();
		private Date_Function Date_Function = new Date_Function();
		protected System.Web.UI.WebControls.TextBox Date1Tbx;
		protected System.Web.UI.WebControls.TextBox Date2Tbx;
		protected System.Web.UI.WebControls.TextBox Date3Tbx;
		protected System.Web.UI.WebControls.Button View4Btn;
		protected System.Web.UI.WebControls.TextBox Date4FromTbx;
		protected System.Web.UI.WebControls.TextBox Cust4Tbx;
		protected System.Web.UI.WebControls.TextBox Date4ToTbx;
		protected System.Web.UI.WebControls.Button Excel4Btn;
		protected System.Web.UI.WebControls.Button View5Btn;
		protected System.Web.UI.WebControls.Button Excel5Btn;
		protected System.Web.UI.WebControls.TextBox Date5FromTbx;
		protected System.Web.UI.WebControls.TextBox Cust5FromTbx;
		protected System.Web.UI.WebControls.TextBox Cust5ToTbx;
		protected System.Web.UI.WebControls.RadioButtonList Opt5Rbl;

		private string[] MonthName = {"January", "Febuary", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			// Put user code to initialize the page here
			sqlconn.ConnectionString = Global.ConnectionStr();	// Connection String
			
			// Create Javascript Menu
			//Response.Write(Session["MenuContent2"].ToString());
			//if(!this.IsStartupScriptRegistered("MenuScript"))	// Past Menu
			//	RegisterStartupScript("MenuScript", Session["MenuScript"].ToString());
			

			// Clear Form
			this.WarningLbl.Text = "";

			if (!IsPostBack)
			{
				HidWarning.Value = "_DoNothing";
			}

			// User Level Control
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.sqlconn = new System.Data.SqlClient.SqlConnection();
			this.Logout_Btn.Click += new System.EventHandler(this.Logout_Btn_Click);
			this.View1Btn.Click += new System.EventHandler(this.Button1_Click);
			this.View2Btn.Click += new System.EventHandler(this.View2Btn_Click);
			this.Date3Tbx.TextChanged += new System.EventHandler(this.Date3Tbx_TextChanged);
			this.View3Btn.Click += new System.EventHandler(this.View3Btn_Click);
			this.View4Btn.Click += new System.EventHandler(this.View4Btn_Click);
			this.Excel4Btn.Click += new System.EventHandler(this.Excel4Btn_Click);
			this.View5Btn.Click += new System.EventHandler(this.View5Btn_Click);
			this.Excel5Btn.Click += new System.EventHandler(this.Excel5Btn_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void Button1_Click(object sender, System.EventArgs e)
		{
			this.WarningLbl.Text = "";
			if (!Date_Function.IsValidDate(this.Date1Tbx.Text.Trim())) 
			{
				this.WarningLbl.Text = "͡ѹ١ͧ";
				GUI_Function.SetFocus(this.Date1Tbx);
				return;
			}

//			string user, password, server, database;
//			user = System.Configuration.ConfigurationSettings.AppSettings["User"].ToString();
//			password = System.Configuration.ConfigurationSettings.AppSettings["Password"].ToString();
//			server = System.Configuration.ConfigurationSettings.AppSettings["Server"].ToString();
//			database = System.Configuration.ConfigurationSettings.AppSettings["Database"].ToString();

			string[] param = new string[2];
			param[0] = MonthName[int.Parse(this.Date1Tbx.Text.Substring(3,2))-1];
			param[1] = Date_Function.ConvertDate_Slash2Dash(this.Date1Tbx.Text.Trim());
//			GeneratePDF.generate_pdf Rpt = new GeneratePDF.generate_pdf(server,database,user,password);
			GeneratePDF.generate_pdf Rpt = (GeneratePDF.generate_pdf)Session["RptClass"];
			Rpt.CreateReport("DDR001.rpt", param, "PDF");
			
		}

		private void View3Btn_Click(object sender, System.EventArgs e)
		{
			this.WarningLbl.Text = "";
			if (!Date_Function.IsValidDate(this.Date3Tbx.Text.Trim())) 
			{
				this.WarningLbl.Text = "͡ѹ١ͧ";
				GUI_Function.SetFocus(this.Date3Tbx);
				return;
			}

//			if (this.Cust3Tbx.Text.Trim == "") 
//			{
//				this.WarningLbl.Text = "سҡ͡ Cust Code ͹";
//				GUI_Function.SetFocus(this.Cust3Tbx);
//				return;
//			}

//			string user, password, server, database;
//			user = System.Configuration.ConfigurationSettings.AppSettings["User"].ToString();
//			password = System.Configuration.ConfigurationSettings.AppSettings["Password"].ToString();
//			server = System.Configuration.ConfigurationSettings.AppSettings["Server"].ToString();
//			database = System.Configuration.ConfigurationSettings.AppSettings["Database"].ToString();

			string[] param = new string[3];
			param[0] = this.Cust3Tbx.Text.Trim();
			param[1] = Date_Function.ConvertDate_Slash2Dash(this.Date3Tbx.Text.Trim());
			param[2] = this.TripDdl.SelectedValue;
//			GeneratePDF.generate_pdf Rpt = new GeneratePDF.generate_pdf(server,database,user,password);
			GeneratePDF.generate_pdf Rpt = (GeneratePDF.generate_pdf)Session["RptClass"];
			Rpt.CreateReport("DDR003.rpt", param, "PDF");
		}

		private void View2Btn_Click(object sender, System.EventArgs e)
		{
			this.WarningLbl.Text = "";
			if (!Date_Function.IsValidDate(this.Date2Tbx.Text.Trim())) 
			{
				this.WarningLbl.Text = "͡ѹ١ͧ";
				GUI_Function.SetFocus(this.Date2Tbx);
				return;
			}

//			string user, password, server, database;
//			user = System.Configuration.ConfigurationSettings.AppSettings["User"].ToString();
//			password = System.Configuration.ConfigurationSettings.AppSettings["Password"].ToString();
//			server = System.Configuration.ConfigurationSettings.AppSettings["Server"].ToString();
//			database = System.Configuration.ConfigurationSettings.AppSettings["Database"].ToString();

			string[] param = new string[1];
			param[0] = Date_Function.ConvertDate_Slash2Dash(this.Date2Tbx.Text.Trim());
//			GeneratePDF.generate_pdf Rpt = new GeneratePDF.generate_pdf(server,database,user,password);
			GeneratePDF.generate_pdf Rpt = (GeneratePDF.generate_pdf)Session["RptClass"];
			Rpt.CreateReport("DDR002.rpt", param, "PDF");
		}

		private void Logout_Btn_Click(object sender, System.EventArgs e)
		{
			Session["LoggedIn"] = "no";
			Session["username"] = "";
			Session.Clear();
			FormsAuthentication.SignOut();
			Response.Write("<script>parent.window.location.replace(\"../LoginForm.aspx\");</script>");
		}

		private void Date3Tbx_TextChanged(object sender, System.EventArgs e)
		{
			this.WarningLbl.Text = "";
			if (this.Date3Tbx.Text.Trim() != "") 
			{
				try 
				{
					SqlDataAdapter DA = new SqlDataAdapter();
					DA.SelectCommand = sqlconn.CreateCommand();
					DA.SelectCommand.CommandText = "select TRIP_NO from CS_DELIVERY_TRIP where DELIVERY_DATE = @DELIVERY_DATE";
					DA.SelectCommand.Parameters.Add("@DELIVERY_DATE", Date_Function.ConvertDate_Slash2Dash(this.Date3Tbx.Text));
					DataTable dt = new DataTable();
					DA.Fill(dt);
					this.TripDdl.DataSource = dt;
					this.TripDdl.DataTextField = "TRIP_NO";
					this.TripDdl.DataValueField = "TRIP_NO";
					this.TripDdl.DataBind();
				}
				catch (Exception Ex) 
				{
					this.WarningLbl.Text = Ex.Message;
				}
			}
		}

		private void View4Btn_Click(object sender, System.EventArgs e)
		{
			this.WarningLbl.Text = "";
			if (!Date_Function.IsValidDate(this.Date4FromTbx.Text.Trim())) 
			{
				this.WarningLbl.Text = "͡ѹ١ͧ";
				GUI_Function.SetFocus(this.Date4FromTbx);
				return;
			}
			if (!Date_Function.IsValidDate(this.Date4ToTbx.Text.Trim())) 
			{
				this.WarningLbl.Text = "͡ѹ١ͧ";
				GUI_Function.SetFocus(this.Date4ToTbx);
				return;
			}

			string[] param = new string[3];
			if (this.Cust4Tbx.Text.Trim() == "")
				param[0] = "0";
			else
				param[0] = this.Cust4Tbx.Text.Trim();
			param[1] = Date_Function.ConvertDate_Slash2Dash(this.Date4FromTbx.Text.Trim());
			param[2] = Date_Function.ConvertDate_Slash2Dash(this.Date4ToTbx.Text.Trim());
			GeneratePDF.generate_pdf Rpt = (GeneratePDF.generate_pdf)Session["RptClass"];
			Rpt.CreateReport("DDR004.rpt", param, "PDF");
		}

		private void Excel4Btn_Click(object sender, System.EventArgs e)
		{
			this.WarningLbl.Text = "";
			if (!Date_Function.IsValidDate(this.Date4FromTbx.Text.Trim())) 
			{
				this.WarningLbl.Text = "͡ѹ١ͧ";
				GUI_Function.SetFocus(this.Date4FromTbx);
				return;
			}
			if (!Date_Function.IsValidDate(this.Date4ToTbx.Text.Trim())) 
			{
				this.WarningLbl.Text = "͡ѹ١ͧ";
				GUI_Function.SetFocus(this.Date4ToTbx);
				return;
			}

			string[] param = new string[3];
			if (this.Cust4Tbx.Text.Trim() == "")
				param[0] = "0";
			else
				param[0] = this.Cust4Tbx.Text.Trim();
			param[1] = Date_Function.ConvertDate_Slash2Dash(this.Date4FromTbx.Text.Trim());
			param[2] = Date_Function.ConvertDate_Slash2Dash(this.Date4ToTbx.Text.Trim());
			GeneratePDF.generate_pdf Rpt = (GeneratePDF.generate_pdf)Session["RptClass"];
			Rpt.CreateReportStream("DDR004.rpt", param, "EXCEL");
		}

		private void View5Btn_Click(object sender, System.EventArgs e)
		{
			this.WarningLbl.Text = "";
			if (!Date_Function.IsValidDate(this.Date5FromTbx.Text.Trim())) 
			{
				this.WarningLbl.Text = "͡ѹ١ͧ";
				GUI_Function.SetFocus(this.Date5FromTbx);
				return;
			}

			string[] param = new string[4];
			if (this.Cust5FromTbx.Text.Trim() == "")
				param[0] = "0";
			else
				param[0] = this.Cust5FromTbx.Text.Trim();
			if (this.Cust5ToTbx.Text.Trim() == "")
				param[1] = "0";
			else
				param[1] = this.Cust5ToTbx.Text.Trim();
			param[2] = Date_Function.ConvertDate_Slash2Dash(this.Date5FromTbx.Text.Trim());
			param[3] = this.Opt5Rbl.SelectedValue.ToString();

			GeneratePDF.generate_pdf Rpt = (GeneratePDF.generate_pdf)Session["RptClass"];
			Rpt.CreateReport("DDR005.rpt", param, "PDF");
		}

		private void Excel5Btn_Click(object sender, System.EventArgs e)
		{
			this.WarningLbl.Text = "";
			if (!Date_Function.IsValidDate(this.Date5FromTbx.Text.Trim())) 
			{
				this.WarningLbl.Text = "͡ѹ١ͧ";
				GUI_Function.SetFocus(this.Date5FromTbx);
				return;
			}

			string[] param = new string[4];
			if (this.Cust5FromTbx.Text.Trim() == "")
				param[0] = "0";
			else
				param[0] = this.Cust5FromTbx.Text.Trim();
			if (this.Cust5ToTbx.Text.Trim() == "")
				param[1] = "0";
			else
				param[1] = this.Cust5ToTbx.Text.Trim();
			param[2] = Date_Function.ConvertDate_Slash2Dash(this.Date5FromTbx.Text.Trim());
			param[3] = this.Opt5Rbl.SelectedValue.ToString();

			GeneratePDF.generate_pdf Rpt = (GeneratePDF.generate_pdf)Session["RptClass"];
			Rpt.CreateReportStream("DDR005.rpt", param, "EXCEL");
		}
	}
}
