using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using System.Text.RegularExpressions;
using System.Web.Security;

namespace CoilCenter3FZ.SaleProgram
{
	/// <summary>
	/// Summary description for CSFZ07_1.
	/// </summary>
	public class CSFZ07_1 : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.HyperLink Print_Lnk;
		protected System.Web.UI.WebControls.Button Button2;
		protected System.Web.UI.WebControls.Button Logout_Btn;
		protected System.Web.UI.WebControls.Label WarningLbl;
		protected System.Web.UI.WebControls.Label Label9;
		protected System.Web.UI.HtmlControls.HtmlInputHidden ScrollPOS;
		protected System.Web.UI.WebControls.TextBox txtCustcode;
		protected System.Web.UI.WebControls.TextBox txtPacklistNo;
		protected System.Web.UI.WebControls.TextBox txtRefNo;
		protected System.Web.UI.WebControls.DataGrid dgPacklist;
		protected System.Web.UI.WebControls.Button btnSave;
		protected System.Web.UI.WebControls.Button btnDelete;
		protected System.Web.UI.WebControls.Button btnClear;
		protected System.Web.UI.WebControls.Button btnUpdate;
		protected System.Web.UI.WebControls.Button btnPrint;
		protected System.Web.UI.HtmlControls.HtmlInputHidden HidWarning;
		protected System.Web.UI.WebControls.RadioButtonList rdbType;
		protected System.Web.UI.WebControls.RadioButtonList rdbPalletType;
		protected UserControl.DatePicker.DatePickerICO DPIDate;
		protected System.Web.UI.WebControls.DropDownList ddlPalletSize;
		protected System.Web.UI.WebControls.DropDownList ddlPalletNo;
		protected System.Web.UI.WebControls.TextBox txtNetWeight;
		protected System.Web.UI.WebControls.TextBox txtGrossWeight;
		protected System.Web.UI.WebControls.TextBox txtRemark;
		protected System.Web.UI.WebControls.Button btnCancel;
		protected System.Data.SqlClient.SqlConnection sqlconn;
		protected System.Web.UI.WebControls.Label lblCustName;
		protected System.Web.UI.WebControls.Label lblQty;
		protected System.Web.UI.WebControls.Label lblWeight;
		protected System.Web.UI.WebControls.Label lblNo;
		protected System.Web.UI.HtmlControls.HtmlInputHidden Hidpack;
		protected System.Web.UI.WebControls.Label lblifcheck;
		protected System.Web.UI.HtmlControls.HtmlInputHidden Hidch;
		protected System.Web.UI.WebControls.CheckBox ConsignCbx;
		protected System.Web.UI.WebControls.TextBox tbxSTArea;
		protected System.Web.UI.WebControls.HyperLink HyperLink1;
		protected System.Web.UI.WebControls.RequiredFieldValidator RequiredFieldValidator5;
		protected System.Web.UI.WebControls.TextBox ActualPackTypeTbx;
		protected System.Web.UI.WebControls.TextBox PackWTTbx;
		protected System.Web.UI.WebControls.DataGrid dgTemp;


		private void Page_Load(object sender, System.EventArgs e)
		{
			sqlconn.ConnectionString = Global.ConnectionStr();	// Connection String
			//Response.Write(Session["MenuContent2"].ToString());
			//if(!this.IsStartupScriptRegistered("MenuScript"))	// Past Menu
			//	RegisterStartupScript("MenuScript", Session["MenuScript"].ToString());
			
			// Javascript Warning Control
			PrepareWarningScript();	

			// Clear Form
			this.WarningLbl.Text = "";

			if (!IsPostBack)
			{//first
				HidWarning.Value = "_DoNothing";
				SetClearPage(true);
				
			}
			else
				if(Hidch.Value != "change")
					this.SetActionCheckDataGrid();

//				if (Utility_Function.chkDBNull(Session["bindgrid"])== "N")
//				{
//					Session["bindgrid"]="Y";
//					BindGridAgain();
//				}
//				else
//					BindGrid(false);

		}

		#region Define valiable
		//Define Use Class Here
		private MSSQL_Function MSSQL_Function = new MSSQL_Function();
		private GUI_Function GUI_Function = new GUI_Function();
		private Utility_Function Utility_Function = new Utility_Function();
		private Date_Function Date_Function = new  Date_Function();
		//
		private const int MAX_DATAGRID_ROW = 20;
		private string sql;
		private enum myDGColumn 
		{
			myCheckBox = 0, No = 1, P_MNo= 2, Spec = 3, Size = 4, Qty = 5, Weight = 6
		}

		double TotalWt;
		double TotalQty;

		#endregion

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			UserControlsInitializeComponent();
			this.HidWarning.ServerChange += new System.EventHandler(this.HidWarning_ServerChange);
			this.Hidch.ServerChange += new System.EventHandler(this.Hidch_ServerChange);
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.sqlconn = new System.Data.SqlClient.SqlConnection();
			this.Logout_Btn.Click += new System.EventHandler(this.Logout_Btn_Click);
			this.rdbType.SelectedIndexChanged += new System.EventHandler(this.rdbType_SelectedIndexChanged);
			this.txtPacklistNo.TextChanged += new System.EventHandler(this.txtPacklistNo_TextChanged);
			this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
			this.ConsignCbx.CheckedChanged += new System.EventHandler(this.ConsignCbx_CheckedChanged);
			this.txtCustcode.TextChanged += new System.EventHandler(this.txtCustcode_TextChanged);
			this.ActualPackTypeTbx.TextChanged += new System.EventHandler(this.ActualPackTypeTbx_TextChanged);
			this.dgPacklist.ItemDataBound += new System.Web.UI.WebControls.DataGridItemEventHandler(this.dgPacklist_ItemDataBound);
			this.rdbPalletType.SelectedIndexChanged += new System.EventHandler(this.rdbPalletType_SelectedIndexChanged);
			this.ddlPalletSize.SelectedIndexChanged += new System.EventHandler(this.ddlPalletSize_SelectedIndexChanged);
			this.tbxSTArea.TextChanged += new System.EventHandler(this.tbxSTArea_TextChanged);
			this.PackWTTbx.TextChanged += new System.EventHandler(this.PackWTTbx_TextChanged);
			this.txtGrossWeight.TextChanged += new System.EventHandler(this.txtGrossWeight_TextChanged);
			this.btnSave.Click += new System.EventHandler(this.btnSave_Click);
			this.btnUpdate.Click += new System.EventHandler(this.btnUpdate_Click);
			this.btnDelete.Click += new System.EventHandler(this.btnDelete_Click);
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		
		private void UserControlsInitializeComponent()
		{
			this.DPIDate.DateChanged += new EventHandler(DPIDate_DateChanged);
		}
		#endregion

		#region JavaScript
		private void PrepareWarningScript()
		{
			string sJavaScript = "<script language=javascript >";
			sJavaScript += "function PrepareWarningScript() {";
			sJavaScript += "	var ButtonClick;";
			sJavaScript += "	switch (Form1.HidWarning.value)";
			sJavaScript += "	{";
			sJavaScript += "		case \"_DoNothing\" :";
			sJavaScript += "			break;";
			sJavaScript += "		case \"NO\" :";
			sJavaScript += "			break;";
			sJavaScript += "		case \"\" :";
			sJavaScript += "			break;";
			sJavaScript += "		case \"CANCELBTN_CLICK\" :";
			/*check*/	sJavaScript += "			ButtonClick = window.confirm('سͧ¡ԡ[' + Form1.txtPacklistNo.value + '] ?');";
			sJavaScript += "			if ( ButtonClick ) {";
			sJavaScript += "				Form1.HidWarning.value = 'CANCELBTN_CLICK_OK';";
			sJavaScript += "				Form1.submit();";
			sJavaScript += "			}";
			sJavaScript += "			else {";
			sJavaScript += "				Form1.HidWarning.value = '';";
			sJavaScript += "			}";
			sJavaScript += "			break;";
			sJavaScript += "		case \"DELBTN_CLICK\" :";
			/*check*/	sJavaScript += "			ButtonClick = window.confirm('سͧź[' + Form1.Hidpack.value + '] ?');";
			sJavaScript += "			if ( ButtonClick ) {";
			sJavaScript += "				Form1.HidWarning.value = 'DELBTN_CLICK_OK';";
			sJavaScript += "				Form1.submit();";
			sJavaScript += "			}";
			sJavaScript += "			else {";
			sJavaScript += "				Form1.HidWarning.value = 'NO';";
			sJavaScript += "			}";
			sJavaScript += "			break;";sJavaScript += "		case \"SAVEBTN_COMPLETE\":";
			sJavaScript += "			alert(\"ѹ֡º\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		case \"SAVEBTN_ERROR\":";
			sJavaScript += "			alert(\"SAVE ERROR\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		case \"CANCELBTN_COMPLETE\":";
			sJavaScript += "			alert(\"¡ԡº\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		case \"ERROR_DATALOCKED\":";
			sJavaScript += "			alert(\"͹١͡ ö¹ŧ\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		case \"ERROR_INVALIDDATE\":";
			sJavaScript += "			alert(\"سҡ͡ѹ١ٻẺ (dd/mm/yyyy)\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		case \"ERROR_REQUIREDATE\":";
			sJavaScript += "			alert(\"سҡ͡ѹ\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		case \"ERROR_REQUIREPACK\":";
			sJavaScript += "			alert(\"سҡ͡ Pack-No 㹵ҧ\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		case \"ERROR_DATAEXIST\":";
			sJavaScript += "			alert(\"Ţ Packing-No к\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		case \"ERROR_NOTFOUND\":";
			sJavaScript += "			alert(\"辺\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		default :";
			sJavaScript += "			alert(Form1.HidWarning.value);";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "	}";
			sJavaScript += "}";
			sJavaScript += "addEvent(window, 'load', new Function('PrepareWarningScript()'));";
			sJavaScript += "</script>";
			if (!IsClientScriptBlockRegistered("PrepareWarningScript")) 
				this.RegisterClientScriptBlock("PrepareWarningScript", sJavaScript);
		}

		private void Alert(string text)
		{
			string alert = 
				" <SCRIPT language='javascript'>"
				+ "  alert('" + text + "');"
				+ " </SCRIPT>";
			RegisterStartupScript("warning",alert);	  
		}
		public void UnLockLocation()
		{
			string vScript  = 
				"<SCRIPT language='javascript'>Form1.ScrollPOS.value = document.body.scrollTop;</SCRIPT>";
			RegisterStartupScript("unlock",vScript);	  
			
		}
		#endregion

		#region Set and bind data 

		private DataTable CreateStructDT()
		{
			DataTable dt = new DataTable();
			dt.Columns.Add ("Select");
			dt.Columns.Add ("No");
			dt.Columns.Add ("pack_no");
			dt.Columns.Add ("mat_spec" );
			dt.Columns.Add ("size" );
			dt.Columns.Add ("qty" );
			dt.Columns.Add ("wt" );
			return dt;
		}

		private void BindGrid(bool first)
		{
			if (!first)
			{
				SetActionDataGrid();
			}
			else
			{
				this.lblWeight.Text = "0";
				this.lblQty.Text = "0";
				DataTable dt = CreateStructDT();
				DataRow dr;
				for (int i = 0; i < MAX_DATAGRID_ROW; i++)
				{
					dr = dt.NewRow();
					dr["No"] = i + 1;
					dt.Rows.Add (dr);
				}
				Session["dt"]= dt; 
				lblifcheck.Text = "0";
				dgPacklist.DataSource = dt.DefaultView;
				dgPacklist.DataBind();
				for (int i = 0; i < MAX_DATAGRID_ROW; i++)
				{
					CheckBox ch = new CheckBox();
					ch = (CheckBox) dgPacklist.Items[i].Cells[(int) myDGColumn.myCheckBox].Controls[1];
					ch.Enabled = false;
					ch.Checked= false;
				}
			}
		}

		private void BindGridAgain()
		{
			this.lblWeight.Text = "0";
			this.lblQty.Text = "0";
			DataTable dt = new DataTable();
			dt = (DataTable)Session["dt"];
			DataTable dtchbox = ReadCheckBoxValue();
			dgPacklist.DataSource = dt.DefaultView;
			dgPacklist.DataBind();
			for (int i = 0; i < MAX_DATAGRID_ROW; i++)
			{
				CheckBox ch = new CheckBox();
				ch = (CheckBox) dgPacklist.Items[i].Cells[(int) myDGColumn.myCheckBox].Controls[1];
				string chvalue = dtchbox.Rows[i]["Select"].ToString();
				if (chvalue.Trim() == "1")
					ch.Checked= true;
				else
					ch.Checked= false;
				TextBox P_MNo = new TextBox();
				P_MNo = (TextBox) dgPacklist.Items[i].Cells[(int) myDGColumn.P_MNo].Controls[1];
				if (i < Convert.ToInt64(lblNo.Text) & P_MNo.Text.Trim() != "")
				{
					P_MNo.ReadOnly = true;
					ch.Enabled = true;
				}
				else
				{
					P_MNo.ReadOnly = false;
					ch.Enabled = false;
				}
			}
			SetfocusGrid();
		}
		private DataTable ReadCheckBoxValue()
		{
			DataTable dt = new DataTable();
			dt.Columns.Add ("Select");
			DataRow dr;
			for (int i=0; i<MAX_DATAGRID_ROW; i++)
			{
				CheckBox ch = new CheckBox();
				ch = (CheckBox) dgPacklist.Items[i].Cells[(int) myDGColumn.myCheckBox].Controls[1];
				dr = dt.NewRow();
				if (ch.Checked == true)
					dr["Select"] = "1";
				else
					dr["Select"] = "0";
				dt.Rows.Add (dr);
	
			}
			Session["checkbox"]= dt;
			lblifcheck.Text = "1";
			return dt; 
		}
		private void SetActionDataGrid()
		{
			this.lblWeight.Text = "0";
			this.lblQty.Text = "0";
			DataTable dtchbox = ReadCheckBoxValue();
			DataTable dt = new DataTable();
			dt = (DataTable)Session["dt"];
			int i;
			string check = CheckDataInDatagrid(dt);
			string consignflag = "";
			if (ConsignCbx.Checked) consignflag = "*";

			if (check == "")
				for (i=0; i<MAX_DATAGRID_ROW; i++)
				{
					TextBox P_MNo = new TextBox();
					P_MNo = (TextBox) dgPacklist.Items[i].Cells[(int) myDGColumn.P_MNo].Controls[1];
					string packno = dt.Rows[i]["pack_no"].ToString();
					if (packno.Trim() !=  P_MNo.Text)
					{
						if (P_MNo.Text.Trim() == "")
						{
							dt.Rows[i]["pack_no"] = System.DBNull.Value;
							dt.Rows[i]["mat_spec"] = System.DBNull.Value;
							dt.Rows[i]["size"] = System.DBNull.Value;
							dt.Rows[i]["qty"] = System.DBNull.Value;
							dt.Rows[i]["wt"]= System.DBNull.Value;
							continue;
						}
						sql = QueryPackMathDetail(P_MNo.Text.Trim(), consignflag ,Convert.ToInt16(this.rdbType.SelectedValue.ToString()));
						DataTable dtpack = Utility_Function.loadDb(sql);
						if (dtpack.Rows.Count > 0)
						{
							dt.Rows[i]["pack_no"] = Utility_Function.chkDBNull(dtpack.Rows[0]["pack_no"].ToString());
							dt.Rows[i]["mat_spec"] = Utility_Function.chkDBNull(dtpack.Rows[0]["mat_spec"].ToString());
							dt.Rows[i]["size"] = Utility_Function.chkDBNull(dtpack.Rows[0]["size"].ToString());
							dt.Rows[i]["qty"] = Utility_Function.chkDBNull(dtpack.Rows[0]["qty"].ToString());
							dt.Rows[i]["wt"] = Utility_Function.chkDBNull(dtpack.Rows[0]["wt"].ToString());
						}
						else
						{
							HidWarning.Value = "Pack/Math No " + P_MNo.Text.Trim() + "  pakage list " ;
							dt.Rows[i]["pack_no"] = System.DBNull.Value;
							dt.Rows[i]["mat_spec"] = System.DBNull.Value;
							dt.Rows[i]["size"] = System.DBNull.Value;
							dt.Rows[i]["qty"] = System.DBNull.Value;
							dt.Rows[i]["wt"]= System.DBNull.Value;
						}
					}// end if
				}// end for
			else
				HidWarning.Value = check;
			Session["dt"]= dt; 
			dgPacklist.DataSource = dt.DefaultView;
			dgPacklist.DataBind();
			for (i = 0; i < MAX_DATAGRID_ROW; i++)
			{
				CheckBox ch = new CheckBox();
				ch = (CheckBox) dgPacklist.Items[i].Cells[(int) myDGColumn.myCheckBox].Controls[1];
				if (this.btnSave.Enabled == true)
				{
					ch.Checked= false;
					ch.Enabled = false;
				}
				else
				{
					string chvalue = dtchbox.Rows[i]["Select"].ToString();
					if (chvalue.Trim() == "1")
						ch.Checked= true;
					else
						ch.Checked= false;
					TextBox P_MNo = new TextBox();
					P_MNo = (TextBox) dgPacklist.Items[i].Cells[(int) myDGColumn.P_MNo].Controls[1];
					if (i < Convert.ToInt64(lblNo.Text) & P_MNo.Text.Trim() != "")
					{
						P_MNo.ReadOnly = true;
						ch.Enabled = true;
					}
					else
					{
						P_MNo.ReadOnly = false;
						ch.Enabled = false;
					}
				}
			}
			SetfocusGrid();
		}//end SetActionDataGrid

		private void SetActionCheckDataGrid()
		{
			this.lblWeight.Text = "0";
			this.lblQty.Text = "0";
			DataTable dtchbox = ReadCheckBoxValue();
			DataTable dt = new DataTable();
			dt = (DataTable)Session["dt"];
			Session["dt"]= dt; 
			dgPacklist.DataSource = dt.DefaultView;
			dgPacklist.DataBind();
			for (int i = 0; i < MAX_DATAGRID_ROW; i++)
			{
				CheckBox ch = new CheckBox();
				ch = (CheckBox) dgPacklist.Items[i].Cells[(int) myDGColumn.myCheckBox].Controls[1];
				if (this.btnSave.Enabled == true)
				{
					ch.Checked= false;
					ch.Enabled = false;
				}
				else
				{
					string chvalue = dtchbox.Rows[i]["Select"].ToString();
					if (chvalue.Trim() == "1")
						ch.Checked= true;
					else
						ch.Checked= false;
					TextBox P_MNo = new TextBox();
					P_MNo = (TextBox) dgPacklist.Items[i].Cells[(int) myDGColumn.P_MNo].Controls[1];
					if (i < Convert.ToInt64(lblNo.Text) & P_MNo.Text.Trim() != "")
					{
						P_MNo.ReadOnly = true;
						ch.Enabled = true;
					}
					else
					{
						P_MNo.ReadOnly = false;
						ch.Enabled = false;
					}
				}
			}
			//SetfocusGrid();
		}//end SetActionDataGrid
		private string CheckDataInDatagrid(DataTable dt)
		{
			string err = "";
			for (int i=0; i<MAX_DATAGRID_ROW; i++)
			{
				TextBox P_MNo = new TextBox();
				P_MNo = (TextBox) dgPacklist.Items[i].Cells[(int) myDGColumn.P_MNo].Controls[1];
				if (P_MNo.Text != "")
				{
					string packno = dt.Rows[i]["pack_no"].ToString();
					if (packno.Trim() !=  P_MNo.Text)
						
						for (int j=0; j<MAX_DATAGRID_ROW; j++)
						{
							if (j != i)
							{
								TextBox P_MNo1 = new TextBox();
								P_MNo1 = (TextBox) dgPacklist.Items[j].Cells[(int) myDGColumn.P_MNo].Controls[1];
								if (P_MNo.Text.Trim() == P_MNo1.Text.Trim())
								{
									err = "Pack/Math No " + P_MNo.Text.Trim() + " ";
									P_MNo1.Text = "";
									this.SetfocusGrid(j);
								}
							}
						}
				}//if (P_MNo.Text != "")
			}
			return err;
		}

		private string QueryPackMathDetail(string pack_no,string consign_flag,int type)
		{
			switch (type) 
			{
				case 1:// F/G used SQL003
					sql ="Select fg.pack_no pack_no, m.mat_spec, fg.size, fg.remain_qty qty, fg.remain_wt wt " +
						" From CS_Finish_Goods fg, CS_Material m Where fg.mat_code = m.mat_code " +
						" And fg.in_flag = '*' And fg.cancel_flag IS NULL " +
						" And fg.out_flag IS NULL And fg.pl_no IS NULL " +
						" And fg.pack_no = '" + pack_no + "'" + //@p_pack_no
						" And ISNULL(fg.consign_flag,'') = ISNULL('" + consign_flag + "','')"; //consign_flag
					break;
				case 2:// M/C used SQL004
					sql ="Select mc.mat_no pack_no, m.mat_spec, mc.size, mc.remain_qty qty, mc.remain_wt wt " +
						 " From CS_Mother_Coil mc, CS_Material m Where mc.mat_code = m.mat_code " +
						 " And mc.in_flag = '*' And mc.cancel_flag IS NULL And mc.out_flag IS NULL " +
						 " And mc.remain_wt = mc.p_remain_wt " +
						 " And mc.pl_no IS NULL And mc.mat_no = '" + pack_no + "'" + //@p_mat_no
						 " And ISNULL(mc.consign_flag,'') = ISNULL('" + consign_flag + "','')"; //consign_flag
					break;
                 default:
					sql = "";
					break;
			}// end switch
			return sql;
		}

		private bool CheckCondition(string PackListNo) 
		{
			bool Allow = false;
			sqlconn.Open();
			try
			{
				SqlCommand Cmd = sqlconn.CreateCommand();
				Cmd.CommandText = " Select CASE WHEN count(*)=0 THEN 'ALLOW' ELSE 'DENY' END Condition "
					+ " From CS_Package_List pl "
					+ " Where pl.pl_no = " + MSSQL_Function.Sql_ConvText(PackListNo)
					+ " And ( "
					+ "    (pl.pl_type = 1 AND EXISTS ( "
					+ "       Select 'X' From CS_Finish_Goods fg "
					+ "       Where fg.pl_no = pl.pl_no "
					//+ "       And (fg.out_flag IS NOT NULL OR fg.out_no IS NOT NULL) "
					//+ "       And (fg.out_flag IS NOT NULL) "
					+ "       And "
					+ "       ( "
					+ "          fg.out_flag IS NOT NULL "
					+ "          OR EXISTS "
					+ "          ( "
					+ "             Select 'X' From CS_DO d "
					+ "             Where d.do_no = fg.out_no "
					+ "             And d.pkl_inv_no IS NOT NULL "
					+ "          ) "
					+ "       ) "
					+ "    )) "
					+ "    OR "
					+ "    (pl.pl_type = 2 AND EXISTS ( "
					+ "       Select 'X' From CS_Mother_Coil mc "
					+ "       Where mc.pl_no = pl.pl_no "
					//+ "       And (mc.out_flag IS NOT NULL OR mc.do_no IS NOT NULL) "
					//+ "       And (mc.out_flag IS NOT NULL) "
					+ "       And "
					+ "       ( "
					+ "          mc.out_flag IS NOT NULL "
					+ "          OR EXISTS "
					+ "          ( "
					+ "             Select 'X' From CS_DO d "
					+ "             Where d.do_no = mc.do_no "
					+ "             And d.pkl_inv_no IS NOT NULL "
					+ "          ) "
					+ "       ) "
					+ "    )) "
					+ " ) ";
				SqlDataReader r = Cmd.ExecuteReader();
				if(r.Read())
				{
					if (r["Condition"].ToString() == "ALLOW")
						Allow = true;
					else
						Allow = false;
				}
				else
				{
					sqlconn.Close();
				}
			}
			catch
			{
				sqlconn.Close();
				Alert("Condition Checker Error");
			}

			return Allow;
		}

		private void SetClearPage(bool setrdb)
		{
			if (setrdb)
			{
				this.rdbType.Items[1].Selected = false;	
				this.rdbType.Items[0].Selected = true;	
			}
			lblNo.Text =  "-1";
			lblifcheck.Text = "0";
			this.rdbPalletType.Items[1].Selected = false;
			this.rdbPalletType.Items[0].Selected = true;
			this.ddlPalletNo.Enabled= true;
			this.ddlPalletSize.Enabled = true;
			this.ConsignCbx.Checked = false;
			this.txtCustcode.Text = "";
			this.lblCustName.Text= "";
			this.ActualPackTypeTbx.Text = "";	// ammer update
			this.txtPacklistNo.Text  = "";
			this.txtRefNo.Text = "";
			this.txtGrossWeight.Text = "";
			this.txtNetWeight.Text = "";
			this.PackWTTbx.Text = "";
			this.txtRemark.Text = "";
			this.DPIDate.SetToNow();
			setToUpdate(true);
			this.btnDelete.Enabled = false;
			this.btnSave.Enabled = true;
			this.btnUpdate.Enabled = false;
			this.btnCancel.Enabled = false;
			GUI_Function.SetFocus(this.txtPacklistNo);
			//-----SQL001-----
			sql = "Select distinct pallet_size From CS_Pallet Where pallet_type = 'S' Order By pallet_size";
			Utility_Function.DDLBind(ddlPalletSize,sql,"pallet_size","pallet_size","--Select a pallet size--","NULL","");
			Utility_Function.DDLClear(this.ddlPalletNo ,"--Select a pallet no--","NULL");
//			//-----CTSQL.List_STArea-----
//			CTSQL ct = new CTSQL();
//			if (sqlconn.State == ConnectionState.Closed)
//				sqlconn.Open();
//			SqlDataReader r = ct.Lst_STArea(sqlconn);
//			this.ddlStock.Items.Clear();
//			this.ddlStock.Items.Add(new ListItem("--Select a Stock area--","NULL"));
//			while (r.Read()) 
//			{
//				this.ddlStock.Items.Add(new ListItem(r["st_area"].ToString(), r["st_area"].ToString()));
//			}
//			sqlconn.Close();
//			//
			this.tbxSTArea.Text = "";
			BindGrid(true);
		}

		private void BindDataGrideForUpdate(bool keepchekbox)
		{
			if (keepchekbox)
				ReadCheckBoxValue();
			else
				lblifcheck.Text = "0";
			this.lblWeight.Text = "0";
			this.lblQty.Text = "0";
			if (this.rdbType.SelectedValue =="1")
			//SQL006
				sql = "Select fg.pack_no pack_no, m.mat_spec, fg.size, fg.remain_qty qty, fg.remain_wt wt " +
					  " From CS_Finish_Goods fg, CS_Material m " +
					  " Where fg.mat_code *= m.mat_code And fg.pl_no = '" + //@p_pl_no
					  this.txtPacklistNo.Text + "' Order By pack_no";
			else////SQL007
				sql ="Select mc.mat_no pack_no, m.mat_spec, mc.size, mc.remain_qty qty, mc.remain_wt wt " +
					 " From CS_Mother_Coil mc, CS_Material m Where mc.mat_code *= m.mat_code " +
					 " And mc.pl_no = '" + //@p_pl_no
					  this.txtPacklistNo.Text + "'Order By pack_no";

			DataTable dt = Utility_Function.loadDb(sql);
			dt.Columns.Add ("No");
			int position = dt.Rows.Count;
			Session["row"] = position;
			DataRow dr;
			for (int i = 0; i < MAX_DATAGRID_ROW; i++)
			{
				if (i > dt.Rows.Count-1 )
				{
				dr = dt.NewRow();
				dr["No"] = i + 1;
				dt.Rows.Add (dr);
				}
				else
					dt.Rows[i]["No"] = i+1;
			}
			Session["dt"]= dt; 
			dgPacklist.DataSource = dt.DefaultView;
			dgPacklist.DataBind();
			if (position == MAX_DATAGRID_ROW)
				GUI_Function.SetFocus(this.rdbPalletType);
			else
				this.SetfocusGrid(position);
			SetGridEnable();
			Hidch.Value = "";
		}

		private  void QueryPacklist()
		{
			//SQL005
			string updtext = "Select pl.pl_no, convert(varchar(10),pl.pl_date,20) pl_date" +
							 ", pl.ref_no, pl.CONSIGN_FLAG, pl.cust_code, c.cust_name, pl.pack_type" +
							 ", pl.pallet_type, pl.pallet_size, pl.pallet_no, pl.st_area" +
							 ", pl.net_wt, pl.gross_wt, pl.remark " +
							 " From CS_Package_List pl, CS_Customer c " +
							 " Where pl.cust_code = c.cust_code " +
							 " And pl.cancel_flag IS NULL " +
							 " And pl.pl_type = " + this.rdbType.SelectedValue + //@p_pl_type
							 " And pl.pl_no = '" + this.txtPacklistNo.Text + "'"; //@p_pl_no
			DataTable dt = Utility_Function.loadDb(updtext);
		
			if(dt.Rows.Count > 0)
			{
				this.txtPacklistNo.Text  = dt.Rows[0]["pl_no"].ToString();
				this.DPIDate.DateText =Date_Function.ConvertDate_Dash2Slash(dt.Rows[0]["pl_date"].ToString());
				this.txtRefNo.Text   =dt.Rows[0]["ref_no"].ToString();
				if (dt.Rows[0]["CONSIGN_FLAG"].ToString() == "*")
					this.ConsignCbx.Checked = true;
				else
					this.ConsignCbx.Checked = false;
				this.txtCustcode.Text =dt.Rows[0]["cust_code"].ToString();
				this.lblCustName.Text =dt.Rows[0]["cust_name"].ToString();
				this.ActualPackTypeTbx.Text = dt.Rows[0]["pack_type"].ToString();
				this.rdbPalletType.SelectedValue = dt.Rows[0]["pallet_type"].ToString();//1
				setPallet();//2
				this.ddlPalletSize.SelectedValue  = Utility_Function.chkDBNull_ReturnNull(dt.Rows[0]["pallet_size"].ToString());//3
				this.setDDLPalletNo();//4
//				string palletNo =  Utility_Function.chkDBNull_ReturnNull(dt.Rows[0]["pallet_no"].ToString ());
//				if (palletNo != "NULL")
//					ddlPalletNo.Items.Add(new ListItem(palletNo,palletNo ));
				this.ddlPalletNo.SelectedValue = Utility_Function.chkDBNull_ReturnNull(dt.Rows[0]["pallet_no"].ToString ());
				this.tbxSTArea.Text = Utility_Function.chkDBNull_ReturnNull(dt.Rows[0]["st_area"].ToString ());
				this.txtNetWeight.Text = dt.Rows[0]["net_wt"].ToString ();
				this.txtGrossWeight.Text = dt.Rows[0]["gross_wt"].ToString ();
				this.txtRemark.Text  = dt.Rows[0]["remark"].ToString ();
				this.WarningLbl.Text = "";
				setToUpdate(false);
				if (CheckCondition(this.txtPacklistNo.Text)) 
				{
					setButton(false,true,true,true);
				}
				else 
				{
					setButton(false,false,false,false);
				}
				this.BindDataGrideForUpdate(false);
			}
			else
			{
				HidWarning.Value = "辺 Package list No." + this.txtPacklistNo.Text;
				this.SetClearPage(false); 
				setToUpdate(true);
				setPallet();
				setDDLPalletNo();
				setButton(true,false,false,false);
				GUI_Function.SetFocus(this.txtPacklistNo);
			}
		}
		private void SetGridEnable()
		{
			lblNo.Text =  "-1";
			for (int i = 0; i < MAX_DATAGRID_ROW; i++)
			{
				CheckBox ch = new CheckBox();
				ch = (CheckBox) dgPacklist.Items[i].Cells[(int) myDGColumn.myCheckBox].Controls[1];
				TextBox P_MNo = new TextBox();
				P_MNo = (TextBox) dgPacklist.Items[i].Cells[(int) myDGColumn.P_MNo].Controls[1];
				if (P_MNo.Text.Trim() != "")
				{
					P_MNo.ReadOnly = true;
					ch.Enabled = true;
				}
				else
				{
					if (lblNo.Text ==  "-1")
						lblNo.Text = i.ToString();
					P_MNo.ReadOnly = false;
					ch.Enabled = false;
				}
			}
			if (lblNo.Text ==  "-1")
				lblNo.Text =  MAX_DATAGRID_ROW.ToString();
		}
		#endregion

		#region Extra funtion

		private void setButton(bool btSave,bool btUpdate,bool btDel,bool btCancel)
		{
			this.btnSave.Enabled = btSave;
			this.btnUpdate.Enabled = btUpdate;
			this.btnDelete.Enabled = btDel;
			this.btnCancel.Enabled = btCancel; 
		}
		private void setToUpdate(bool enable)
		{
			this.DPIDate.Enabled =  enable;
			this.txtRefNo.Enabled = true;
			this.txtCustcode.Enabled = enable;
			this.ConsignCbx.Enabled = enable;
			this.ActualPackTypeTbx.Enabled = true;	// ammer update
		}
		private void setPallet()
		{
			if (this.rdbPalletType.SelectedValue =="S"  ) //steel
			{
				//-----SQL001-----
				sql = "Select distinct pallet_size From CS_Pallet Where pallet_type = 'S' Order By pallet_size";
				Utility_Function.DDLBind(ddlPalletSize,sql,"pallet_size","pallet_size","--Select a pallet size--","NULL","");
				this.ddlPalletSize.Enabled = true;

				this.ddlPalletNo.Enabled = true;
			}
			else if (this.rdbPalletType.SelectedValue =="W"  ) //wood
			{
				//-----SQL001-----
				sql = "Select distinct pallet_size From CS_Pallet Where pallet_type = 'W' Order By pallet_size";
				Utility_Function.DDLBind(ddlPalletSize,sql,"pallet_size","pallet_size","--Select a pallet size--","NULL","");
				this.ddlPalletSize.Enabled = true;

				Utility_Function.DDLClear(this.ddlPalletNo ,"--Select a pallet no--","NULL");
				this.ddlPalletNo.Enabled = false;
			}
			else //rack
			{
				this.ddlPalletSize.ClearSelection();
				this.ddlPalletSize.Items[0].Selected  = true;
				this.ddlPalletSize.Enabled = false;

				Utility_Function.DDLClear(this.ddlPalletNo ,"--Select a pallet no--","NULL");
				this.ddlPalletNo.Enabled = false;

			}
		}
		private void setDDLPalletNo()
		{
			string pl_no = this.txtPacklistNo.Text.Trim();
			string type = this.rdbPalletType.SelectedValue;

//			if (pl_no != "")
//				pl_no = "OR pl_no = '" + pl_no + "'";//@p_pl_no)
			//SQL002
				sql = "Select pallet_no From CS_Pallet P Where pallet_type = '" + type + "' " +
					" And cancel_flag IS NULL And pallet_size = '" + this.ddlPalletSize.SelectedValue + "' " +
					" And ( (status = 'E' AND pl_no IS NULL) " +
					"   OR (status = 'F' AND pl_no = '" + pl_no + "') " + 
					"   OR EXISTS (SELECT 'X' FROM CS_PACKAGE_LIST PL WHERE PL.PALLET_NO=P.PALLET_NO AND PL.PALLET_SIZE=P.PALLET_SIZE AND PL.PL_NO='" + pl_no + "') " +
					" ) Order By pallet_no ";

			Utility_Function.DDLBind(this.ddlPalletNo ,sql,"pallet_no","pallet_no","--Select a pallet no--","NULL","");
		}

		private void SetfocusGrid()
		{
			bool empty = false;
			for (int i = 0; i < MAX_DATAGRID_ROW; i++)
			{
				TextBox P_MNo = new TextBox();
				P_MNo = (TextBox) dgPacklist.Items[i].Cells[(int) myDGColumn.P_MNo].Controls[1];
				if (!empty)
				{
					if (P_MNo.Text == "")
					{
						empty = true;
						RegisterStartupScript("focus", "<script language='JavaScript'>" +
							" Form1." + P_MNo.ClientID + ".focus(); " +
							//" Form1." + P_MNo.ClientID + ".select(); " +
							"<" + "/script>");

					}
				}// if(!empty)
			}//end for
			if (!empty)
				GUI_Function.SetFocus(this.rdbPalletType);

		}//end SetfocusGrid
		private void SetfocusGrid(int row)
		{
			TextBox P_MNo = new TextBox();
			P_MNo = (TextBox) dgPacklist.Items[row].Cells[(int) myDGColumn.P_MNo].Controls[1];
//			RegisterStartupScript("focus", "<script language='JavaScript'>" +
//				" Form1." + P_MNo.ClientID + ".focus(); " +
//				" Form1." + P_MNo.ClientID + ".select(); " +
//				"<" + "/script>");
			SetDataGridItemFocus(P_MNo);
		}
		private void SetDataGridItemFocus(System.Web.UI.Control Control)
		{
			string vScript  = 
				"<SCRIPT language='javascript'>document.getElementById(\'" + Control.ClientID + "\').focus()</SCRIPT>";
			Control.Page.RegisterStartupScript("Focus", vScript);
		}

		private bool CheckGridforupdate()
		{
			string err = "";
			for (int i = 0; i < MAX_DATAGRID_ROW; i++)
			{
				CheckBox ch = new CheckBox();
				ch = (CheckBox) dgPacklist.Items[i].Cells[(int) myDGColumn.myCheckBox].Controls[1];
				if (ch.Checked)
					err = "ö update ա͡ Pack/Math no ͧź";
			}
			if (err =="")
				return true;
			else
			{
				BindDataGrideForUpdate(true);
				DataTable dt = (DataTable)Session["checkbox"];
				for (int i = 0; i < MAX_DATAGRID_ROW; i++)
				{
					CheckBox ch = new CheckBox();
					ch = (CheckBox) dgPacklist.Items[i].Cells[(int) myDGColumn.myCheckBox].Controls[1];
					string chvalue = dt.Rows[i]["Select"].ToString();
					if (chvalue.Trim() == "1")
						ch.Checked= true;
					else
						ch.Checked= false;
				}
				this.SetfocusGrid();
				HidWarning.Value = err;
				return false;
			}
		}

		private bool CheckData()
		{
			string err = "";

			if (this.txtCustcode.Text.Trim() == "")
			{
				err ="سҡ͡ Cust code \n";
				GUI_Function.SetFocus(this.txtCustcode);
			}
			if (this.ActualPackTypeTbx.Text.Trim() == "")
			{
				err ="سҡ͡ Acutal Pack Type \n";
				GUI_Function.SetFocus(this.ActualPackTypeTbx);
			}
//			if (this.txtRefNo.Text.Trim() == "")
//			{
//				err = err + "س͡ Ref NO \n";
//				GUI_Function.SetFocus(this.txtRefNo);
//			}
			if (this.DPIDate.DateText == "")
				err = err + "س͡ Date \n";
			if (this.tbxSTArea.Text.Trim() == "")
			{
				err = err + "سҡ͡ stock area \n";
				GUI_Function.SetFocus(this.tbxSTArea);
			}
			if (this.rdbPalletType.SelectedValue.ToString() == "S") 
			{
				if (this.ddlPalletSize.SelectedValue == "NULL" || this.ddlPalletNo.SelectedValue == "NULL")
				{
					err = err + "سҡ͡͡ Pallet Size  Pallet No  \n";
					GUI_Function.SetFocus(this.ddlPalletSize);
				}
			}
			else if (this.rdbPalletType.SelectedValue.ToString() == "W") 
			{
				if (this.ddlPalletSize.SelectedValue == "NULL")
				{
					err = err + "سҡ͡͡ Pallet Size \n";
					GUI_Function.SetFocus(this.ddlPalletSize);
				}
			}
			
			try
			{
				if (Double.Parse(this.txtGrossWeight.Text) < Double.Parse(this.lblWeight.Text))
				{
					err =  err + "Gross Weight ͧҡҡѺ Net Weight\n";
					this.txtGrossWeight.Text= this.lblWeight.Text;
					GUI_Function.SetFocus(this.txtGrossWeight);
				}
			}
			catch
			{
				err =  err + "Gross Weight ͧ繵Ţҹ\n";
				this.txtGrossWeight.Text = this.lblWeight.Text;
				GUI_Function.SetFocus(this.txtGrossWeight);
			}		
			HidWarning.Value = err;
			if (err == "")
				return true;
			else
				return false;
		}
		#endregion

		#region Datagrid
		
		private void dgPacklist_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
		{
			string strQty;
			string strWt;
			if ( e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
			{
				TextBox pn = (TextBox) e.Item.Cells[(int) myDGColumn.P_MNo].Controls[1];
				pn.Attributes.Add("onkeyup", "CheckKeyPress('" + Hidch.ClientID +"')");
				int index = e.Item.ItemIndex ;
				DataTable dt = new DataTable();
				string chvalue= "";
				if (this.lblifcheck.Text.Trim() == "1")
				{
					dt = (DataTable)Session["checkbox"];
					chvalue = dt.Rows[index]["Select"].ToString();
				}
				if (chvalue.Trim() != "1")
				{
					TextBox qty = (TextBox) e.Item.Cells[(int) myDGColumn.Qty].Controls[1];
					TextBox wt = (TextBox) e.Item.Cells[(int) myDGColumn.Weight].Controls[1];
					if ( qty.Text.Trim() == "" ) 
						strQty = "0";
					else
						strQty = qty.Text.Trim();

					if ( wt.Text.Trim() == "" ) 
						strWt = "0";
					else
						strWt = wt.Text.Trim();
				
					TotalQty = Double.Parse(this.lblQty.Text);
					TotalQty += Double.Parse(strQty);
					this.lblQty.Text = TotalQty.ToString();  

					TotalWt =Double.Parse(this.lblWeight.Text);
					TotalWt += Double.Parse(strWt);
					this.lblWeight.Text = TotalWt.ToString();
				}

			}
			else if( e.Item.ItemType == ListItemType.Footer)
			{
				((Label) e.Item.Cells[(int) myDGColumn.Qty].Controls[1]).Text = string.Format("{0:n}",TotalQty);
				((Label) e.Item.Cells[(int) myDGColumn.Weight].Controls[1]).Text = string.Format("{0:n}", TotalWt);
				this.txtNetWeight.Text = TotalWt.ToString();
				//CalGrossWt();
			}
		}

		#endregion

		#region Logout

		private void Logout_Btn_Click(object sender, System.EventArgs e)
		{
			Session["LoggedIn"] = "no";
			Session["username"] = "";
			Session.Clear();
			FormsAuthentication.SignOut();
			Response.Write("<script>parent.window.location.replace(\"../LoginForm.aspx\");</script>");
		}
		#endregion

		#region Action Button

		private void btnClear_Click(object sender, System.EventArgs e)
		{
			SetClearPage(false);
			this.UnLockLocation();
		}
		private void btnUpdate_Click(object sender, System.EventArgs e)
		{
			if (this.CheckGridforupdate())
				if (this.CheckData())
					UpdateDB();
		}
		private void btnSave_Click(object sender, System.EventArgs e)
		{
			if (this.CheckData())
				InsertDB();
		}

		private void btnDelete_Click(object sender, System.EventArgs e)
		{
			if (this.CheckData())
			{
				string pack= "";
				for (int i=0; i<MAX_DATAGRID_ROW; i++)
				{
					CheckBox ch = new CheckBox();
					ch = (CheckBox) dgPacklist.Items[i].Cells[(int) myDGColumn.myCheckBox].Controls[1];
					if (ch.Checked)
					{
						TextBox P_MNo = new TextBox();
						P_MNo = (TextBox) dgPacklist.Items[i].Cells[(int) myDGColumn.P_MNo].Controls[1];
						pack = pack + P_MNo.Text + "  ";
//						TextBox wt = (TextBox) dgPacklist.Items[i].Cells[(int) myDGColumn.Weight].Controls[1];
//						TotalWt =Double.Parse(this.lblWeight.Text);
//						TotalWt -= Double.Parse(wt.Text);
//						this.lblWeight.Text = TotalWt.ToString();

					}
				}
				if (pack == "")
					HidWarning.Value = "͡ pack/math no ͧź";
				else
				{
					this.Hidpack.Value = pack;
					HidWarning.Value = "DELBTN_CLICK";
					Session["bindgrid"]= "N";
				}
			}
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			if (this.CheckData())
				HidWarning.Value = "CANCELBTN_CLICK";
		}

		#endregion

		#region Action Textbox

		private void txtPacklistNo_TextChanged(object sender, System.EventArgs e)
		{ 
			QueryPacklist();
			//Session["bindgrid"]= "N";

		}
		private void txtCustcode_TextChanged(object sender, System.EventArgs e)
		{
			CTSQL ct = new CTSQL();
			sqlconn.Open();
			SqlDataReader r = ct.Get_Customer (this.txtCustcode.Text  , sqlconn);
			if(r.Read())
			{
				this.lblCustName.Text = r["cust_name"].ToString();
				this.txtCustcode.Text = r["cust_code"].ToString();
				setButton(true,false,false,false);
				GUI_Function.SetFocus(this.ActualPackTypeTbx);
				//SetfocusGrid();
			}
			else
			{
				HidWarning.Value = "辺 Cust code " + this.txtCustcode.Text;
				this.lblCustName.Text = "";
				this.txtCustcode.Text = "";
				GUI_Function.SetFocus(this.txtCustcode );
				setButton(true,false,false,false);
			}
			sqlconn.Close(); 
		}

		private void txtGrossWeight_TextChanged(object sender, System.EventArgs e)
		{
//			try
//			{
//				if (this.txtGrossWeight.Text.IndexOf(".") != -1 || this.txtGrossWeight.Text.IndexOf("-") != -1
//					|| this.txtGrossWeight.Text == "0")
//				{
//					this.HidWarning.Value = "Gross Weight ͧ繨ӹǹ Դź ٹ";
//					GUI_Function.SetFocus(this.txtGrossWeight);
//				}
//				else if (Double.Parse(this.txtGrossWeight.Text) < Double.Parse(this.lblWeight.Text))
//				{
//					HidWarning.Value = "Gross Weight ͧҡҡѺ Net Weight";
//					this.txtGrossWeight.Text= this.lblWeight.Text;
//					GUI_Function.SetFocus(this.txtGrossWeight);
//
//				}
//				else
//					GUI_Function.SetFocus(this.txtRemark);
//			}
//			catch
//			{
//				HidWarning.Value = "Gross Weight ͧ繵Ţҹ";
//				this.txtGrossWeight.Text = this.lblWeight.Text;
//				GUI_Function.SetFocus(this.txtGrossWeight);
//			}

			GUI_Function.LockLocation(this, "LOCATION_DETAIL");
			if (this.txtGrossWeight.Text == "") 
			{
				this.txtGrossWeight.Text= this.lblWeight.Text;
			}
			else if (Double.Parse(this.txtGrossWeight.Text) < Double.Parse(this.lblWeight.Text))
			{
				HidWarning.Value = "Gross Weight ͧҡҡѺ Net Weight";
				this.txtGrossWeight.Text= this.lblWeight.Text;
				GUI_Function.SetFocus(this.txtGrossWeight);
			}
		}
		private void HidWarning_ServerChange(object sender, System.EventArgs e)
		{
			if (HidWarning.Value == "CANCELBTN_CLICK_OK")
			{
				CancelDB();
			}
			if (HidWarning.Value == "DELBTN_CLICK_OK")
			{
				DeleteDB();
				SetfocusGrid();
			}
			if (HidWarning.Value == "NO")
			{
				QueryPacklist();
				//SetGridEnable();
			}
		}

		private void Hidch_ServerChange(object sender, System.EventArgs e)
		{
			if (Hidch.Value == "change")
			{
				BindGrid(false);
				Hidch.Value= "";
			}

		}
		#endregion

		#region Action Radio button

		private void rdbType_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			SetClearPage(false);
		}

		private void rdbPalletType_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			GUI_Function.LockLocation(this, "LOCATION_DETAIL");
			if (this.rdbPalletType.SelectedValue =="S"  ) //steel
			{
				//-----SQL001-----
				sql = "Select distinct pallet_size From CS_Pallet Where pallet_type = 'S' Order By pallet_size";
				Utility_Function.DDLBind(ddlPalletSize,sql,"pallet_size","pallet_size","--Select a pallet size--","NULL","");
				this.ddlPalletSize.Enabled = true;

				this.ddlPalletNo.Enabled = true;
				this.GUI_Function.SetFocus(this.ddlPalletSize);
			}
			else if (this.rdbPalletType.SelectedValue =="W"  ) //wood
			{
				//-----SQL001-----
				sql = "Select distinct pallet_size From CS_Pallet Where pallet_type = 'W' Order By pallet_size";
				Utility_Function.DDLBind(ddlPalletSize,sql,"pallet_size","pallet_size","--Select a pallet size--","NULL","");
				this.ddlPalletSize.Enabled = true;

				Utility_Function.DDLClear(this.ddlPalletNo ,"--Select a pallet no--","NULL");
				this.ddlPalletNo.Enabled = false;
				this.GUI_Function.SetFocus(this.ddlPalletSize);
			}
			else //rack
			{
				this.ddlPalletSize.ClearSelection();
				this.ddlPalletSize.Items[0].Selected  = true;
				this.ddlPalletSize.Enabled = false;

				Utility_Function.DDLClear(this.ddlPalletNo ,"--Select a pallet no--","NULL");
				this.ddlPalletNo.Enabled = false;
				this.GUI_Function.SetFocus(this.tbxSTArea);
			}
		}

		#endregion

		#region Action Dropdown list

		private void ddlPalletSize_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			GUI_Function.LockLocation(this, "LOCATION_DETAIL");
			this.setDDLPalletNo();
		}
		#endregion

		#region Transaction
		private bool UpdateDB()
		{
			try
			{
				sqlconn.Open();
				SqlCommand cmd = sqlconn.CreateCommand();
				cmd.CommandText = "CSFZ07_1_PROC002";
				cmd.CommandType = CommandType.StoredProcedure;
				cmd.Parameters.Add (new SqlParameter("@p_pl_no", this.txtPacklistNo.Text ));
				cmd.Parameters.Add (new SqlParameter("@p_pl_type", this.rdbType.SelectedValue.ToString()));
				cmd.Parameters.Add (new SqlParameter("@p_pl_date", Date_Function.ConvertDate_Slash2Dash(this.DPIDate.DateText )));
				cmd.Parameters.Add (new SqlParameter("@p_ref_no", this.txtRefNo.Text));
				if (ConsignCbx.Checked)
					cmd.Parameters.Add (new SqlParameter("@p_consign_flag", "*"));
				else
					cmd.Parameters.Add (new SqlParameter("@p_consign_flag", DBNull.Value));
				cmd.Parameters.Add (new SqlParameter("@p_cust_code", this.txtCustcode.Text));
				cmd.Parameters.Add (new SqlParameter("@p_pack_type", this.ActualPackTypeTbx.Text));		// newly add by ammer
				int i;
				for (i=0; i<MAX_DATAGRID_ROW; i++)
				{
					TextBox P_MNo = new TextBox();
					P_MNo = (TextBox) dgPacklist.Items[i].Cells[(int) myDGColumn.P_MNo].Controls[1];
					if (i >= Convert.ToInt64(lblNo.Text))
					{
						string s;
						s =Utility_Function.chkDBNull(P_MNo.Text.Trim());
						if (s=="")
							cmd.Parameters.Add (new SqlParameter("@p_pack_no_"+ string.Format("{0:0#}",i+1),  DBNull.Value));
						else
							cmd.Parameters.Add (new SqlParameter("@p_pack_no_"+ string.Format("{0:0#}",i+1),  s));

					}
					else
						cmd.Parameters.Add (new SqlParameter("@p_pack_no_"+ string.Format("{0:0#}",i+1),  DBNull.Value));

				}

				cmd.Parameters.Add (new SqlParameter("@p_pallet_type", this.rdbPalletType.SelectedValue.ToString()));
				if (this.ddlPalletSize.SelectedIndex == 0)
					cmd.Parameters.Add (new SqlParameter("@p_pallet_size", DBNull.Value));
				else
					cmd.Parameters.Add (new SqlParameter("@p_pallet_size", this.ddlPalletSize.SelectedValue.ToString()));
				if (this.ddlPalletNo.SelectedIndex == 0)
					cmd.Parameters.Add (new SqlParameter("@p_pallet_no", DBNull.Value));
				else
					cmd.Parameters.Add (new SqlParameter("@p_pallet_no", this.ddlPalletNo.SelectedValue.ToString()));
				cmd.Parameters.Add (new SqlParameter("@p_st_area", this.tbxSTArea.Text.Trim()));
				cmd.Parameters.Add (new SqlParameter("@p_net_wt", this.lblWeight.Text));
				cmd.Parameters.Add (new SqlParameter("@p_gross_wt", Regex.Replace(this.txtGrossWeight.Text,",","")));
				cmd.Parameters.Add (new SqlParameter("@p_remark", this.txtRemark.Text));
				cmd.Parameters.Add (new SqlParameter("@p_user_id", Session["username"].ToString()));
				cmd.ExecuteNonQuery();
				sqlconn.Close();
				this.HidWarning.Value  = "SAVEBTN_COMPLETE";
				QueryPacklist();
				//SetGridEnable();
				return true;
			}
			catch (SqlException e) 
			{
				string errorMessages = "";

				for (int i=0; i < e.Errors.Count; i++)
				{
					errorMessages += "Message: " + e.Errors[i].Message + "\n" ;
				}
				HidWarning.Value=errorMessages;
				return false;
			}
		}//end updata
		private bool InsertDB()
		{
			try
			{
				sqlconn.Open();
				SqlCommand cmd = sqlconn.CreateCommand();
				cmd.CommandText = "CSFZ07_1_PROC001";
				cmd.CommandType = CommandType.StoredProcedure;
				cmd.Parameters.Add (new SqlParameter("@p_pl_type", this.rdbType.SelectedValue.ToString()));
				cmd.Parameters.Add (new SqlParameter("@p_pl_date", Date_Function.ConvertDate_Slash2Dash(this.DPIDate.DateText )));
				cmd.Parameters.Add (new SqlParameter("@p_ref_no", this.txtRefNo.Text));
				if (ConsignCbx.Checked)
					cmd.Parameters.Add (new SqlParameter("@p_consign_flag", "*"));
				else
					cmd.Parameters.Add (new SqlParameter("@p_consign_flag", DBNull.Value));
				cmd.Parameters.Add (new SqlParameter("@p_cust_code", this.txtCustcode.Text));
				cmd.Parameters.Add (new SqlParameter("@p_pack_type", this.ActualPackTypeTbx.Text));		// newly add by ammer
				int i;
				for (i=0; i<MAX_DATAGRID_ROW; i++)
				{
					TextBox P_MNo = new TextBox();
					P_MNo = (TextBox) dgPacklist.Items[i].Cells[(int) myDGColumn.P_MNo].Controls[1];
					string s;
					s =Utility_Function.chkDBNull(P_MNo.Text.Trim());
					if (s=="")
						cmd.Parameters.Add (new SqlParameter("@p_pack_no_"+ string.Format("{0:0#}",i+1), DBNull.Value));
					else
						cmd.Parameters.Add (new SqlParameter("@p_pack_no_"+ string.Format("{0:0#}",i+1), s));

				}
				cmd.Parameters.Add (new SqlParameter("@p_pallet_type", this.rdbPalletType.SelectedValue.ToString()));
				if (this.ddlPalletSize.SelectedIndex == 0)
					cmd.Parameters.Add (new SqlParameter("@p_pallet_size", DBNull.Value));
				else
					cmd.Parameters.Add (new SqlParameter("@p_pallet_size", this.ddlPalletSize.SelectedValue.ToString()));
				if (this.ddlPalletNo.SelectedIndex == 0)
					cmd.Parameters.Add (new SqlParameter("@p_pallet_no", DBNull.Value));
				else
					cmd.Parameters.Add (new SqlParameter("@p_pallet_no", this.ddlPalletNo.SelectedValue.ToString()));
				cmd.Parameters.Add (new SqlParameter("@p_st_area", this.tbxSTArea.Text.Trim()));
				cmd.Parameters.Add (new SqlParameter("@p_net_wt", this.lblWeight.Text));
				cmd.Parameters.Add (new SqlParameter("@p_gross_wt", Regex.Replace(this.txtGrossWeight.Text,",","")));//this.txtGrossWeight.Text));
				cmd.Parameters.Add (new SqlParameter("@p_remark", this.txtRemark.Text));
				cmd.Parameters.Add (new SqlParameter("@p_user_id", Session["username"].ToString()));
				SqlParameter sampParm = cmd.Parameters.Add("@out_pl_no", SqlDbType.VarChar,255);
				sampParm.Direction = ParameterDirection.Output;

				object o = cmd.ExecuteScalar();
				this.txtPacklistNo.Text = sampParm.Value.ToString();
				sqlconn.Close();
				this.HidWarning.Value  = "SAVEBTN_COMPLETE";
				QueryPacklist();
				//SetGridEnable();
				return true;
			}
			catch (SqlException e) 
			{
				string errorMessages = "";

				for (int i=0; i < e.Errors.Count; i++)
				{
					errorMessages += "Message: " + e.Errors[i].Message + "\n" ;
				}
				HidWarning.Value=errorMessages;
				return false;
			}
		}

		private bool DeleteDB()
		{
			try 
			{
				sqlconn.Open();
				SqlCommand cmd = sqlconn.CreateCommand();
				cmd.CommandText = "CSFZ07_1_PROC003";
				cmd.CommandType = CommandType.StoredProcedure;
				cmd.Parameters.Add (new SqlParameter("@p_pl_no", this.txtPacklistNo.Text ));
				cmd.Parameters.Add (new SqlParameter("@p_pl_type", this.rdbType.SelectedValue.ToString()));
//				DataTable dt = new DataTable();
//				dt = (DataTable)Session["checkbox"];
				for (int i=0; i<MAX_DATAGRID_ROW; i++)
				{
					CheckBox ch = new CheckBox();
					ch = (CheckBox) dgPacklist.Items[i].Cells[(int) myDGColumn.myCheckBox].Controls[1];
//					if (dt.Rows[i]["Select"].ToString() == "1")
					if (ch.Checked)
					{
						TextBox P_MNo = new TextBox();
						P_MNo = (TextBox) dgPacklist.Items[i].Cells[(int) myDGColumn.P_MNo].Controls[1];
						string s;
						s =Utility_Function.chkDBNull(P_MNo.Text.Trim());
						if (s=="")
							cmd.Parameters.Add (new SqlParameter("@p_pack_no_"+ string.Format("{0:0#}",i+1), DBNull.Value));
						else
							cmd.Parameters.Add (new SqlParameter("@p_pack_no_"+ string.Format("{0:0#}",i+1), s));
					}
					else
						cmd.Parameters.Add (new SqlParameter("@p_pack_no_"+ string.Format("{0:0#}",i+1),  DBNull.Value));
				}
				cmd.Parameters.Add (new SqlParameter("@p_net_wt", this.lblWeight.Text));
				cmd.Parameters.Add (new SqlParameter("@p_gross_wt", Regex.Replace(this.txtGrossWeight.Text,",","")));//this.txtGrossWeight.Text));
				cmd.Parameters.Add (new SqlParameter("@p_user_id", Session["username"].ToString()));

				cmd.ExecuteNonQuery();
				sqlconn.Close();
				QueryPacklist();
				this.HidWarning.Value  = "ź pack º";
				return true;
			}
			catch (SqlException e) 
			{
				string errorMessages = "";

				for (int i=0; i < e.Errors.Count; i++)
				{
					errorMessages += "Message: " + e.Errors[i].Message + "\n" ;
				}
				HidWarning.Value=errorMessages;
				return false;
			}
		}

		private bool CancelDB()
		{
			try 
			{
				sqlconn.Open();
				SqlCommand cmd = sqlconn.CreateCommand();
				cmd.CommandText = "CSFZ07_1_PROC004";
				cmd.CommandType = CommandType.StoredProcedure;
				cmd.Parameters.Add (new SqlParameter("@p_pl_no", this.txtPacklistNo.Text ));
				cmd.Parameters.Add (new SqlParameter("@p_pl_type", this.rdbType.SelectedValue.ToString()));

				cmd.Parameters.Add (new SqlParameter("@p_user_id", Session["username"].ToString()));

				cmd.ExecuteNonQuery();
				sqlconn.Close();
				this.HidWarning.Value  = "CANCELBTN_COMPLETE";
				//			QueryPacklist();
				//			SetGridEnable();
				SetClearPage(true);
				this.UnLockLocation();
				return true;
			}
			catch (SqlException e) 
			{
				string errorMessages = "";

				for (int i=0; i < e.Errors.Count; i++)
				{
					errorMessages += "Message: " + e.Errors[i].Message + "\n" ;
				}
				HidWarning.Value=errorMessages;
				return false;
			}
		}
		#endregion

		private void ConsignCbx_CheckedChanged(object sender, System.EventArgs e)
		{
			if (txtPacklistNo.Text == "") 
			{
				BindGrid(true);
				GUI_Function.SetFocus(this.txtCustcode);
			}
		}

		private void btnPrint_Click(object sender, System.EventArgs e)
		{
			string user, password, server, database;
			user = System.Configuration.ConfigurationSettings.AppSettings["User"].ToString();
			password = System.Configuration.ConfigurationSettings.AppSettings["Password"].ToString();
			server = System.Configuration.ConfigurationSettings.AppSettings["Server"].ToString();
			database = System.Configuration.ConfigurationSettings.AppSettings["Database"].ToString();

			string[] param = new string[1];
			param[0] = this.txtPacklistNo.Text.Trim();
			GeneratePDF.generate_pdf Rpt = new GeneratePDF.generate_pdf(server,database,user,password);
			Rpt.CreateReport("CSFZR071.rpt",param,"PDF");
		}

		private void tbxSTArea_TextChanged(object sender, System.EventArgs e)
		{
			GUI_Function.LockLocation(this, "LOCATION_DETAIL");
			string STArea = tbxSTArea.Text.Trim();

			sqlconn.Open();
			try
			{
				CTSQL ct = new CTSQL();
				SqlDataReader r = ct.Get_STArea(STArea, sqlconn);
				if(r.Read())
				{
					this.tbxSTArea.Text = r["st_area"].ToString();
					sqlconn.Close();
					GUI_Function.SetFocus(this.PackWTTbx);
				}
				else
				{
					sqlconn.Close();
					this.tbxSTArea.Text = "";
					Alert("This Stock Area does not exist");
					GUI_Function.SetFocus(this.tbxSTArea);
				}
			}
			catch
			{
				sqlconn.Close();
				Alert("Stock Area Checker Error");
				GUI_Function.SetFocus(this.tbxSTArea);
			}
		}

		private void DPIDate_DateChanged(object sender, EventArgs e)
		{
			if (this.DPIDate.WarningText == "")
				GUI_Function.SetFocus(this.txtRefNo);
		}

		private void ActualPackTypeTbx_TextChanged(object sender, System.EventArgs e)
		{
			string PackType = ActualPackTypeTbx.Text.Trim();

			if (PackType != "") 
			{
				try
				{
					sqlconn.Open();
					CTSQL ct = new CTSQL();
					SqlDataReader r = ct.Get_PackType(PackType, sqlconn);
					if(r.Read())
					{
						this.ActualPackTypeTbx.Text = r["pack_type"].ToString();
						//GUI_Function.SetFocus(this.txtGrossWeight);
					}
					else
					{
						this.ActualPackTypeTbx.Text = "";
						Alert("This Pack Type does not exist");
						GUI_Function.SetFocus(this.ActualPackTypeTbx);
					}
				}
				catch
				{
				
					Alert("Pack Type Checker Error");
					GUI_Function.SetFocus(this.ActualPackTypeTbx);
				}
				finally 
				{
					sqlconn.Close();
				}
			}
		}

		private void PackWTTbx_TextChanged(object sender, System.EventArgs e)
		{
			GUI_Function.SetFocus(this.PackWTTbx);
			GUI_Function.LockLocation(this, "LOCATION_DETAIL");
			if (this.PackWTTbx.Text.Trim() == "")
				this.txtGrossWeight.Text = this.txtNetWeight.Text;
			else
				CalGrossWt();
		}

		private void CalGrossWt() 
		{
			try 
			{
				double NetWt = double.Parse(this.txtNetWeight.Text.Trim());
				double PackWt = double.Parse(this.PackWTTbx.Text.Trim());

				this.txtGrossWeight.Text = (NetWt + PackWt).ToString();
			}
			catch
			{
				this.txtGrossWeight.Text = this.txtNetWeight.Text;
			}
		}

	}//end class CSFZ07_1
}//end namespace
