using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Globalization;
using System.Data.SqlClient;
using System.Text.RegularExpressions;
using System.Web.Security;

namespace CoilCenter3FZ.SaleProgram
{
	/// <summary>
	/// Summary description for CSFZ08_1.
	/// </summary>
	public class CSFZ08_1 : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.HyperLink Print_Lnk;
		protected System.Web.UI.WebControls.Button Button2;
		protected System.Web.UI.WebControls.Button Logout_Btn;
		protected System.Web.UI.WebControls.Label WarningLbl;
		protected System.Web.UI.WebControls.RadioButtonList rdbType;
		protected System.Web.UI.WebControls.TextBox txtCustcode;
		protected System.Web.UI.WebControls.Label lblCustName;
		protected System.Web.UI.WebControls.RequiredFieldValidator RequiredFieldValidator5;
		protected System.Web.UI.WebControls.DataGrid dgPacklist;
		protected System.Web.UI.WebControls.TextBox txtNetWeight;
		protected System.Web.UI.WebControls.TextBox txtGrossWeight;
		protected System.Web.UI.WebControls.TextBox txtRemark;
		protected System.Web.UI.WebControls.Button btnSave;
		protected System.Web.UI.WebControls.Button btnUpdate;
		protected System.Web.UI.WebControls.Button btnClear;
		protected System.Web.UI.WebControls.Button btnPrint;
		protected System.Web.UI.WebControls.Label lblQty;
		protected System.Web.UI.WebControls.Label lblWeight;
		protected System.Web.UI.WebControls.Label lblNo;
		protected System.Web.UI.HtmlControls.HtmlInputHidden ScrollPOS;
		protected System.Web.UI.WebControls.TextBox txtOrderNo;
		protected System.Web.UI.WebControls.TextBox txtDONo;
		protected System.Web.UI.WebControls.TextBox txtContractNo;
		protected System.Web.UI.WebControls.TextBox txtDueDate;
		protected System.Web.UI.WebControls.CheckBox chConsign;
		protected System.Web.UI.WebControls.CheckBox chCustPO;
		protected System.Web.UI.WebControls.Label lbAddress1;
		protected System.Web.UI.WebControls.Label lbAddress2;
		protected System.Data.SqlClient.SqlConnection sqlconn;
		protected System.Web.UI.WebControls.TextBox txtTerm;
		protected System.Web.UI.HtmlControls.HtmlInputHidden HidWarning;
		protected System.Web.UI.WebControls.Label lblDetail;
		protected System.Web.UI.WebControls.Label lblpkNo;
		protected System.Web.UI.WebControls.DropDownList ddlNo;
		protected System.Web.UI.WebControls.RequiredFieldValidator Requiredfieldvalidator7;
		protected System.Web.UI.HtmlControls.HtmlInputHidden Hidpack;
		protected System.Web.UI.HtmlControls.HtmlInputHidden Hidch;
		protected System.Web.UI.WebControls.RequiredFieldValidator Requiredfieldvalidator1;
		protected System.Web.UI.WebControls.HyperLink HyperLink1;
		protected System.Web.UI.WebControls.CheckBox ChkIgnoreWHCode;
		protected UserControl.DatePicker.DatePickerICO DPIDate;

		private void Page_Load(object sender, System.EventArgs e)
		{
			sqlconn.ConnectionString = Global.ConnectionStr();	// Connection String
			//Response.Write(Session["MenuContent2"].ToString());
			//if(!this.IsStartupScriptRegistered("MenuScript"))	// Past Menu
			//	RegisterStartupScript("MenuScript", Session["MenuScript"].ToString());

			// Javascript Warning Control
			PrepareWarningScript();	

			// Clear Form
			this.WarningLbl.Text = "";

			if (!IsPostBack)
			{//first
				HidWarning.Value = "_DoNothing";
				SetClearPage(true);
			}
//			else
//				if (Utility_Function.chkDBNull(Session["bindgrid"])== "N")
//				Session["bindgrid"]="Y";
//			else
//				BindGrid(false);
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			//this.DPIDate.onShowCalendar += new System.EventHandler(this.DPIDate_onShowCalendar);
			//this.DPIDate.onHideCalendar += new System.EventHandler(this.DPIDate_onHideCalendar);
			this.DPIDate.DateChanged += new System.EventHandler(this.DPIDate_DateChanged);
			this.Hidch.ServerChange += new System.EventHandler(this.Hidch_ServerChange);
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.sqlconn = new System.Data.SqlClient.SqlConnection();
			this.Logout_Btn.Click += new System.EventHandler(this.Logout_Btn_Click);
			this.rdbType.SelectedIndexChanged += new System.EventHandler(this.rdbType_SelectedIndexChanged);
			this.txtDONo.TextChanged += new System.EventHandler(this.txtDONo_TextChanged);
			this.txtContractNo.TextChanged += new System.EventHandler(this.txtContractNo_TextChanged);
			this.chConsign.CheckedChanged += new System.EventHandler(this.chConsign_CheckedChanged);
			this.txtCustcode.TextChanged += new System.EventHandler(this.txtCustcode_TextChanged);
			this.dgPacklist.ItemCreated += new System.Web.UI.WebControls.DataGridItemEventHandler(this.dgPacklist_ItemCreated);
			this.dgPacklist.ItemDataBound += new System.Web.UI.WebControls.DataGridItemEventHandler(this.dgPacklist_ItemDataBound);
			this.txtGrossWeight.TextChanged += new System.EventHandler(this.txtGrossWeight_TextChanged);
			this.btnSave.Click += new System.EventHandler(this.btnSave_Click);
			this.btnUpdate.Click += new System.EventHandler(this.btnUpdate_Click);
			this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
			this.btnPrint.Click += new System.EventHandler(this.btnPrint_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		#region Define valiable
		//Define Use Class Here
		private MSSQL_Function MSSQL_Function = new MSSQL_Function();
		private GUI_Function GUI_Function = new GUI_Function();
		private Utility_Function Utility_Function = new Utility_Function();
		private Date_Function Date_Function = new  Date_Function();
		//
		private const int MAX_DATAGRID_ROW = 12;
		private string sql;
		private enum myDGColumn 
		{
			No = 0, P_MNo= 1, Spec = 2, Size = 3, Qty = 4, Weight = 5,WH = 6,ST=7,commo=8,commoid = 9
		}

		double TotalWt;
		double TotalQty;

		#endregion

		#region JavaScript
		private void PrepareWarningScript()
		{
			string sJavaScript = "<script language=javascript >";
			sJavaScript += "function PrepareWarningScript() {";
			sJavaScript += "	var ButtonClick;";
			sJavaScript += "	switch (Form1.HidWarning.value)";
			sJavaScript += "	{";
			sJavaScript += "		case \"_DoNothing\" :";
			sJavaScript += "			break;";
			sJavaScript += "		case \"\" :";
			sJavaScript += "			break;";
			sJavaScript += "		case \"CANCELBTN_CLICK\" :";
			/*check*/	sJavaScript += "			ButtonClick = window.confirm('سͧ¡ԡ[' + Form1.txtDONo.value + '] ?');";
			sJavaScript += "			if ( ButtonClick ) {";
			sJavaScript += "				Form1.HidWarning.value = 'CANCELBTN_CLICK_OK';";
			sJavaScript += "				Form1.submit();";
			sJavaScript += "			}";
			sJavaScript += "			else {";
			sJavaScript += "				Form1.HidWarning.value = '';";
			sJavaScript += "			}";
			sJavaScript += "			break;";
			sJavaScript += "		case \"DELBTN_CLICK\" :";
			/*check*/	sJavaScript += "			ButtonClick = window.confirm('سͧź[' + Form1.Hidpack.value + '] ?');";
			sJavaScript += "			if ( ButtonClick ) {";
			sJavaScript += "				Form1.HidWarning.value = 'DELBTN_CLICK_OK';";
			sJavaScript += "				Form1.submit();";
			sJavaScript += "			}";
			sJavaScript += "			else {";
			sJavaScript += "				Form1.HidWarning.value = '';";
			sJavaScript += "			}";
			sJavaScript += "			break;";sJavaScript += "		case \"SAVEBTN_COMPLETE\":";
			sJavaScript += "			alert(\"ѹ֡º\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		case \"SAVEBTN_ERROR\":";
			sJavaScript += "			alert(\"SAVE ERROR\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		case \"CANCELBTN_COMPLETE\":";
			sJavaScript += "			alert(\"¡ԡº\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		case \"ERROR_DATALOCKED\":";
			sJavaScript += "			alert(\"͹١͡ ö¹ŧ\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		case \"ERROR_INVALIDDATE\":";
			sJavaScript += "			alert(\"سҡ͡ѹ١ٻẺ (dd/mm/yyyy)\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		case \"ERROR_REQUIREDATE\":";
			sJavaScript += "			alert(\"سҡ͡ѹ\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		case \"ERROR_REQUIREPACK\":";
			sJavaScript += "			alert(\"سҡ͡ Pack-No 㹵ҧ\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		case \"ERROR_DATAEXIST\":";
			sJavaScript += "			alert(\"Ţ Packing-No к\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		case \"ERROR_NOTFOUND\":";
			sJavaScript += "			alert(\"辺\");";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "		default :";
			sJavaScript += "			alert(Form1.HidWarning.value);";
			sJavaScript += "			Form1.HidWarning.value = '';";
			sJavaScript += "			break;";
			sJavaScript += "	}";
			sJavaScript += "}";
			sJavaScript += "addEvent(window, 'load', new Function('PrepareWarningScript()'));";
			sJavaScript += "</script>";
			if (!IsClientScriptBlockRegistered("PrepareWarningScript")) 
				this.RegisterClientScriptBlock("PrepareWarningScript", sJavaScript);
		}

		private void Alert(string text)
		{
			string alert = 
				" <SCRIPT language='javascript'>"
				+ "  alert('" + text + "');"
				+ " </SCRIPT>";
			RegisterStartupScript("warning",alert);	  
		}
		public void UnLockLocation()
		{
			string vScript  = 
				"<SCRIPT language='javascript'>Form1.ScrollPOS.value = document.body.scrollTop;</SCRIPT>";
			RegisterStartupScript("unlock",vScript);	  
			
		}
		#endregion

		#region Clear and initial 

		private void SetClearPage(bool setrdb)
		{
			if (setrdb)
			{
				this.rdbType.Items[1].Selected = false;	
				this.rdbType.Items[0].Selected = true;	
			}
			lblNo.Text =  "-1";
			this.txtDONo.Text = "";
			this.txtTerm.Text = "0";
			if (this.DPIDate.DateText == "")
				this.DPIDate.SetToNow();
			this.chCustPO.Checked = false;
			this.chConsign.Checked = false;
			this.txtContractNo.Text = "";
			this.txtOrderNo.Text = "";
			CalDueDate(false);
			this.chConsign.Checked = false;
			this.txtCustcode.Text = "";
			this.lblCustName.Text = "";
			this.chCustPO.Checked= false;
			this.lbAddress1.Text = "";
			this.lbAddress2.Text= "";
			this.txtNetWeight.Text="";
			this.txtGrossWeight.Text = "";
			this.txtRemark.Text = "";
			this.lblDetail.Text = "";
			this.lblDetail.Text = "";
			this.ddlNo.Items.Clear();
			this.btnSave.Enabled = true;
			this.btnUpdate.Enabled= false;
			setToUpdate(true);
			BindGrid(true);
			GUI_Function.SetFocus(this.txtDONo);

		}
		private DataTable CreateStructDT()
		{
			DataTable dt = new DataTable();
			//dt.Columns.Add ("Select");
			dt.Columns.Add ("No");
			dt.Columns.Add ("pack_no");
			dt.Columns.Add ("mat_spec" );
			dt.Columns.Add ("size" );
			dt.Columns.Add ("qty" );
			dt.Columns.Add ("wt" );
			dt.Columns.Add ("wh_code" );
			dt.Columns.Add ("detail1" );
			dt.Columns.Add ("comm_id" );
			return dt;
		}
		private void setClearCust()
		{
			this.txtCustcode.Text = "";
			this.lbAddress1.Text = "";
			this.lbAddress2.Text = "";
			this.txtTerm.Text = "0";
			this.chCustPO.Checked = false;
			this.lblCustName.Text = "";
		}

		#endregion

		#region set session of dropdown commodity
		
		private void ReadCommodity()
		{
			DataTable dt = new DataTable();
			dt.Columns.Add ("comm_id");
			for (int i=0; i<dgPacklist.Items.Count; i++)
			{
				DropDownList ddl = (DropDownList) dgPacklist.Items[i].Cells[(int) myDGColumn.commo].Controls[1];
				string comid = ddl.SelectedValue.ToString();
				DataRow dr = dt.NewRow();
				dr["comm_id"]= comid;
				dt.Rows.Add (dr);
			}
			Session["ddl"]= dt;
		}

		#endregion

		#region Set and bind data 

		private string QueryPackMathDetail(string pack_no,int type)
		{
			string consign;
			if (this.chConsign.Checked) 
				consign = "*";
			else
				consign = "";
			switch (type) 
			{
				case 1:// F/G used SQL003
					sql ="Select fg.pack_no, CASE fg.chgspec_flag WHEN '*' THEN fg.new_spec ELSE " +
						 "(select m.mat_spec from CS_Material m where fg.mat_code = m.mat_code) END mat_spec " +
						 ", CASE fg.chgspec_flag WHEN '*' THEN fg.new_size ELSE fg.size END size " +
						 " , fg.remain_qty qty, fg.remain_wt wt, fg.wh_code, fg.part_code detail1, NULL comm_id " +
						 " from CS_Finish_Goods fg where fg.in_flag = '*' " +
						 " And fg.cancel_flag IS NULL And fg.out_mc IS NULL " +
						 " And fg.out_flag IS NULL And out_no IS NULL " +
						 " And fg.in_date <= convert(datetime,'"+ 
						 Date_Function.ConvertDate_Slash2Dash(this.DPIDate.DateText) + "',20) " + //,@p_do_date
						 " And ISNULL(fg.consign_flag,'') = ISNULL('" + consign + "','') " + //@p_consign_flag
						 "And fg.pack_no = '" + pack_no + "'"; //@p_pack_no

					break;
				case 2:// M/C used SQL005
					sql ="Select mc.mat_no pack_no, m.mat_spec, mc.size, mc.remain_qty qty, mc.remain_wt wt, mc.wh_code, mc.mat_code detail1 " +
						 ", NULL comm_id from CS_Mother_Coil mc, CS_Material m where mc.mat_code = m.mat_code " +
						 " And mc.cancel_flag IS NULL And mc.in_flag = '*' "+
						 " And mc.out_flag IS NULL And mc.do_no IS NULL And mc.remain_wt = mc.p_remain_wt " +
						 " And mc.in_date <= convert(datetime,'" + 
						 Date_Function.ConvertDate_Slash2Dash(this.DPIDate.DateText) + "',20) " + //,@p_do_date
						 " And ISNULL(mc.consign_flag,'') = ISNULL('" + consign + "','') " + //@p_consign_flag
						 " And mc.mat_no = '" + pack_no + "'"; //@p_pack_no

					break;
				default:
					sql = "";
					break;
			}// end switch
			return sql;
		}

		private string QueryPackMathPO(string pack_no,int type)
		{
			string condi;
			switch (type) 
			{
				case 1:// F/G used SQL004
					sql =" cpo.cancel_flag IS NULL And cpo.mat_code = CASE WHEN fg.chgspec_flag='*' THEN fg.new_mat ELSE fg.mat_code END " +
						 " And cpo.size = CASE WHEN fg.chgspec_flag='*' THEN fg.new_size ELSE fg.size END " +
						 " And cpo.cust_code = '" + this.txtCustcode.Text.Trim() + "'" +//@p_cust_code
						 " And cpo.cpo_no = '" + this.txtContractNo.Text.Trim() + "'" +//@p_contract_no
						 " And fg.pack_no = '" + pack_no + "'" ;//@p_pack_no
					condi = Utility_Function.GetValueDB("CASE WHEN count(*)=0 THEN 'DENY' ELSE 'ALLOW' END ", 
						"CS_Customer_PO cpo, CS_Finish_Goods fg",sql).ToString();

					break;

				case 2:// M/C used SQL006
					sql =" cpo.cancel_flag IS NULL And cpo.mat_code = mc.mat_code " +
						 " And cpo.size = mc.size And cpo.cust_code = '" + this.txtCustcode.Text.Trim() + "'" +//@p_cust_code
						 " And cpo.cpo_no = '" + this.txtContractNo.Text.Trim() + "'" + //@p_contract_no
						 " And mc.mat_no = '" + pack_no + "'" ;//@p_mat_no

					condi = Utility_Function.GetValueDB("CASE WHEN count(*)=0 THEN 'DENY' ELSE 'ALLOW' END ", 
						"CS_Customer_PO cpo, CS_Mother_Coil mc",sql).ToString();
					break;
				default:
					condi = "";
					break;
			}// end switch
			return condi;
		}

		private void ShowDetail(DataTable dtpack)
		{
				string packno = "";
				for (int i=0; i<MAX_DATAGRID_ROW; i++)
					packno = packno + Utility_Function.chkDBNull_ReturnNull_(dtpack.Rows[i]["pack_no"].ToString())+ ",";
			
				packno = packno.Substring(0,packno.Length-1);
				string pl_type =this.rdbType.SelectedValue.ToString();
				//SQL008
				sql = "Select A.pl_no pl_no, A.pack_no pack_no From " + 
					" ( Select 1 pl_type, pack_no pack_no, pl_no From CS_Finish_Goods Where pl_no IS NOT NULL " +
					" UNION Select 2 pl_type, mat_no pack_no, pl_no From CS_Mother_Coil Where pl_no IS NOT NULL ) A " +
					"  Where A.pl_type = '" + pl_type + "'" +//@p_pl_type
					" And A.pl_no IN ( Select pl_no From CS_Finish_Goods Where 1='" + pl_type + "'" +//@p_pl_type
					" And pack_no IN ( " + packno + 
					/*@p_pack_no01, @p_pack_no02, @p_pack_no03, @p_pack_no04
					, @p_pack_no05, @p_pack_no06, @p_pack_no07, @p_pack_no08
					, @p_pack_no09, @p_pack_no10, @p_pack_no11, @p_pack_no12*/
					" ) UNION Select pl_no From CS_Mother_Coil Where 2='" + pl_type + "'" +//@p_pl_type
					" And mat_no IN (" + packno +" )) Order By pl_no, pack_no " ;
				/*@p_mat_no01, @p_mat_no02, @p_mat_no03, @p_mat_no04
				  , @p_mat_no05, @p_mat_no06, @p_mat_no07, @p_mat_no08
				  , @p_mat_no09, @p_mat_no10, @p_mat_no11, @p_mat_no12*/ 
				DataTable dt = Utility_Function.loadDb(sql);
				string detail = "";
				string pl_no = "";
				this.lblpkNo.Text= "";
				this.ddlNo.Items.Clear();
				for (int i = 0; i <dt.Rows.Count; i++)
				{
					string no = dt.Rows[i]["pack_no"].ToString();
					if (pl_no != dt.Rows[i]["pl_no"].ToString())
					{
						pl_no = dt.Rows[i]["pl_no"].ToString();
						if (detail != "")
							detail = detail + "]<br>" + pl_no + ":[" + no;
						else
							detail = detail + pl_no + ":[" + no;
					}
					else
						detail = detail + "," + no;
					ddlNo.Items.Add(new ListItem(no, no));
					this.lblpkNo.Text= this.lblpkNo.Text + dt.Rows[i]["pack_no"].ToString() + ",";
				}//end for
				if (detail != "")
				{
					detail = detail + "]";
					this.lblpkNo.Text = this.lblpkNo.Text.Substring(0,this.lblpkNo.Text.Length-1);
				}
				this.lblDetail.Text = detail;
		}

        private void SetActionDataGrid()
		{
			this.lblWeight.Text = "0";
			this.lblQty.Text = "0";
			ReadCommodity();//read ddl select value keep session["ddl"]
			DataTable dt = new DataTable();
			dt = (DataTable)Session["dt"];
			int j = -1;
			bool empty = false;
			this.lblDetail.Text= "";
			string check = CheckDataInDatagrid(dt);

			if (check == "")
				for (int i=0; i<MAX_DATAGRID_ROW; i++)
				{
					TextBox P_MNo = new TextBox();
					P_MNo = (TextBox) dgPacklist.Items[i].Cells[(int) myDGColumn.P_MNo].Controls[1];
					string packno = dt.Rows[i]["pack_no"].ToString();
					if (!empty)
					{ //search position to set focus
						if (packno.Trim()=="")
						{
							j = i;
							empty = true;
						}
					}
					if (packno.Trim() !=  P_MNo.Text)
					{
						sql = QueryPackMathDetail(P_MNo.Text.Trim(),Convert.ToInt16(this.rdbType.SelectedValue.ToString()));
						DataTable dtpack = Utility_Function.loadDb(sql);
						if (dtpack.Rows.Count > 0)
						{
							j = i+1;

							string comid = Utility_Function.chkDBNull(dtpack.Rows[0]["comm_id"].ToString());
							if (comid== "")
								comid ="0";

							if (this.chCustPO.Checked)
							{
								string condi = QueryPackMathPO(P_MNo.Text.Trim(),Convert.ToInt16(this.rdbType.SelectedValue.ToString()));
								if (condi =="DENY")
								{
									HidWarning.Value = "Customer P/O Ѻ " + P_MNo.Text + " ó";
									dt.Rows[i]["pack_no"] = System.DBNull.Value;
									dt.Rows[i]["mat_spec"] = System.DBNull.Value;
									dt.Rows[i]["size"] =System.DBNull.Value;
									dt.Rows[i]["qty"] = System.DBNull.Value;
									dt.Rows[i]["wt"] = System.DBNull.Value;
									dt.Rows[i]["wh_code"] = System.DBNull.Value;
									dt.Rows[i]["detail1"] = System.DBNull.Value;
									dt.Rows[i]["comm_id"] = "0";
								}
								else if (dtpack.Rows[0]["wh_code"].ToString().IndexOf("GD") == -1 && this.ChkIgnoreWHCode.Checked == false) 
								{
									HidWarning.Value = "Pack  WH ǹͧ GD";
									dt.Rows[i]["pack_no"] = System.DBNull.Value;
									dt.Rows[i]["mat_spec"] = System.DBNull.Value;
									dt.Rows[i]["size"] =System.DBNull.Value;
									dt.Rows[i]["qty"] = System.DBNull.Value;
									dt.Rows[i]["wt"] = System.DBNull.Value;
									dt.Rows[i]["wh_code"] = System.DBNull.Value;
									dt.Rows[i]["detail1"] = System.DBNull.Value;
									dt.Rows[i]["comm_id"] = "0";
								}
								else
								{
									dt.Rows[i]["pack_no"] = Utility_Function.chkDBNull(dtpack.Rows[0]["pack_no"].ToString());
									dt.Rows[i]["mat_spec"] = Utility_Function.chkDBNull(dtpack.Rows[0]["mat_spec"].ToString());
									dt.Rows[i]["size"] = Utility_Function.chkDBNull(dtpack.Rows[0]["size"].ToString());
									dt.Rows[i]["qty"] = Utility_Function.chkDBNull(dtpack.Rows[0]["qty"].ToString());
									dt.Rows[i]["wt"] = Utility_Function.chkDBNull(dtpack.Rows[0]["wt"].ToString());
									dt.Rows[i]["wh_code"] = Utility_Function.chkDBNull(dtpack.Rows[0]["wh_code"].ToString());
									dt.Rows[i]["detail1"] = Utility_Function.chkDBNull(dtpack.Rows[0]["detail1"].ToString());
									dt.Rows[i]["comm_id"] =comid;
								}
							}
							else
							{
								dt.Rows[i]["pack_no"] = Utility_Function.chkDBNull(dtpack.Rows[0]["pack_no"].ToString());
								dt.Rows[i]["mat_spec"] = Utility_Function.chkDBNull(dtpack.Rows[0]["mat_spec"].ToString());
								dt.Rows[i]["size"] = Utility_Function.chkDBNull(dtpack.Rows[0]["size"].ToString());
								dt.Rows[i]["qty"] = Utility_Function.chkDBNull(dtpack.Rows[0]["qty"].ToString());
								dt.Rows[i]["wt"] = Utility_Function.chkDBNull(dtpack.Rows[0]["wt"].ToString());
								dt.Rows[i]["wh_code"] = Utility_Function.chkDBNull(dtpack.Rows[0]["wh_code"].ToString());
								dt.Rows[i]["detail1"] = Utility_Function.chkDBNull(dtpack.Rows[0]["detail1"].ToString());
								dt.Rows[i]["comm_id"] =comid;
							}
						}
						else
						{
							HidWarning.Value = " Pack/Math No " + P_MNo.Text.Trim();
							dt.Rows[i]["pack_no"] = System.DBNull.Value;
							dt.Rows[i]["mat_spec"] = System.DBNull.Value;
							dt.Rows[i]["size"] =System.DBNull.Value;
							dt.Rows[i]["qty"] =System.DBNull.Value;
							dt.Rows[i]["wt"] = System.DBNull.Value;
							dt.Rows[i]["wh_code"] = System.DBNull.Value;
							dt.Rows[i]["detail1"] = System.DBNull.Value;
							dt.Rows[i]["comm_id"] ="0";
						}//end if (dtpack.Rows.Count > 0)
					
			//		else
		//				dt.Rows[i]["No"] = i.ToString();
					}// end  if (packno.Trim() !=  P_MNo.Text)
				}// end for
			else
				HidWarning.Value = check;

			Session["dt"]= dt; 
			dgPacklist.DataSource = dt.DefaultView;
			dgPacklist.DataBind();
			if (empty)
				SetfocusGrid(j);
			else
				GUI_Function.SetFocus(this.txtGrossWeight);

			DataTable dtddl = new DataTable();
			dtddl = (DataTable)Session["ddl"];
			for (int i = 0; i < MAX_DATAGRID_ROW; i++)
			{
				TextBox P_MNo = new TextBox();
				P_MNo = (TextBox) dgPacklist.Items[i].Cells[(int) myDGColumn.P_MNo].Controls[1];
				DropDownList ddl = (DropDownList) dgPacklist.Items[i].Cells[(int) myDGColumn.commo].Controls[1];
				this.setDDlCommo(ddl,dtddl.Rows[i]["comm_id"].ToString());
				if (i < Convert.ToInt64(lblNo.Text) & P_MNo.Text.Trim() != "")
				{
					P_MNo.ReadOnly = true;
					ddl.Enabled = false;
				}
				else
				{
					P_MNo.ReadOnly = false;
					ddl.Enabled = true;
				}
			}
			
			//Ammer Update 02/03/2006 - Auto Cal Gross Weight
			string pack_mat_no = "";
			for (int i =0; i<MAX_DATAGRID_ROW; i++) 
			{
				if (i < dt.Rows.Count)
					pack_mat_no = pack_mat_no + Utility_Function.chkDBNull_ReturnNull_(dt.Rows[i]["pack_no"].ToString())+ ",";
				else
					pack_mat_no = pack_mat_no + " NUll" + ",";
			}
			pack_mat_no.Remove(pack_mat_no.Length-1, 1);	// remove last comma
			
			if (dt.Rows.Count > 0)
			{
				pack_mat_no = pack_mat_no.Substring(0,pack_mat_no.Length-1);
				string pl_type =this.rdbType.SelectedValue.ToString();
				// SQL011
				string SQL11 = " Select ISNULL(sum(A.gross_wt),0) gross_wt "
					+ " From CS_Package_List A "
					+ " Where A.pl_type = '" + pl_type + "'"
					+ " And A.pl_no IN "
					+ " ( "
					+ "    Select pl_no From CS_Finish_Goods Where 1= '" + pl_type + "' And pack_no IN "
					+ "      ( " + pack_mat_no + " ) "
					/*+ "      (@p_pack_no01, @p_pack_no02, @p_pack_no03, @p_pack_no04 "
						+ "       , @p_pack_no05, @p_pack_no06, @p_pack_no07, @p_pack_no08 "
						+ "       , @p_pack_no09, @p_pack_no10, @p_pack_no11, @p_pack_no12) "*/
					+ "    UNION "
					+ "    Select pl_no From CS_Mother_Coil Where 2= '" + pl_type + "' And mat_no IN "
					+ "      ( " + pack_mat_no + " ) "
					/*+ "       (@p_mat_no01, @p_mat_no02, @p_mat_no03, @p_mat_no04 "
						+ "       , @p_mat_no05, @p_mat_no06, @p_mat_no07, @p_mat_no08 "
						+ "       , @p_mat_no09, @p_mat_no10, @p_mat_no11, @p_mat_no12) "*/
					+ " ) ";
				sqlconn.Open();
				SqlDataReader r = MSSQL_Function.DbQuery(sqlconn, SQL11);
				if(r.Read())
				{
					double grosswt = double.Parse(r["gross_wt"].ToString());
					this.txtGrossWeight.Text = grosswt.ToString("#0");
				}
				sqlconn.Close();
			}
			///////////

			//setDDlCommo();
			ShowDetail(dt);
	}

		private string CheckDataInDatagrid(DataTable dt)
		{
			string err = "";
			for (int i=0; i<MAX_DATAGRID_ROW; i++)
			{
				TextBox P_MNo = new TextBox();
				P_MNo = (TextBox) dgPacklist.Items[i].Cells[(int) myDGColumn.P_MNo].Controls[1];
				if (P_MNo.Text != "")
				{
					string packno = dt.Rows[i]["pack_no"].ToString();
					if (packno.Trim() !=  P_MNo.Text)
						
						for (int j=0; j<MAX_DATAGRID_ROW; j++)
						{
							if (j != i)
							{
								TextBox P_MNo1 = new TextBox();
								P_MNo1 = (TextBox) dgPacklist.Items[j].Cells[(int) myDGColumn.P_MNo].Controls[1];
								if (P_MNo.Text.Trim() == P_MNo1.Text.Trim())
								{
									err = "Pack/Math No ";
									P_MNo1.Text = "";
									this.SetfocusGrid(j);
								}
							}
						}
				}//if (P_MNo.Text != "")
			}
			return err;
		}

		private void BindGrid(bool first)
		{
			// For F/G - M/C selected change
			if (this.rdbType.SelectedIndex == 0)
				this.dgPacklist.Columns[7].HeaderText = "Part Code";
			else
				this.dgPacklist.Columns[7].HeaderText = "Mat Code";

			if (!first)
			{
					SetActionDataGrid();
			}
			else
			{
				this.lblWeight.Text = "0";
				this.lblQty.Text = "0";
				DataTable dt = CreateStructDT();
				DataRow dr;
				for (int i = 0; i < MAX_DATAGRID_ROW; i++)
				{
					dr = dt.NewRow();
					dr["No"] = i + 1;
					dr["comm_id"] = "0";
					dt.Rows.Add (dr);
					
				}
				Session["dt"]= dt; 
				dgPacklist.DataSource = dt.DefaultView;
				dgPacklist.DataBind( );
				setDDlCommo();
			}
		}

		private void setDDlCommo()
		{
			for (int i = 0; i < MAX_DATAGRID_ROW; i++)
			{
				DropDownList ddl = (DropDownList) dgPacklist.Items[i].Cells[(int) myDGColumn.commo].Controls[1];
				string comid = dgPacklist.Items[i].Cells[(int) myDGColumn.commoid].Text;
				if (comid.Trim() == "")
					comid = "0";
				//SQL0010
				sql = " Select cm.comm_id, cm.comm_desc "
					+ " From CS_Commodity cm, CS_Customer c "
					+ " Where cm.cust_code = c.cust_code "
					+ " And cm.status = 'Y' "
					+ " And cm.cust_code = " + MSSQL_Function.Sql_ConvText(this.txtCustcode.Text.Trim())
					+ " UNION "
					+ " Select cm.comm_id, cm.comm_desc "
					+ " From CS_Commodity cm, CS_Finish_Goods fg "
					+ " Where cm.comm_id = fg.out_comm_id "
					+ " And fg.out_no = " + MSSQL_Function.Sql_ConvText(this.txtDONo.Text.Trim())
					+ " And '1' = " + MSSQL_Function.Sql_ConvText(this.rdbType.SelectedValue)
					+ " UNION "
					+ " Select cm.comm_id, cm.comm_desc "
					+ " From CS_Commodity cm, CS_Mother_Coil mc "
					+ " Where cm.comm_id = mc.out_comm_id "
					+ " And mc.do_no = " + MSSQL_Function.Sql_ConvText(this.txtDONo.Text.Trim())
					+ " And '2' = " + MSSQL_Function.Sql_ConvText(this.rdbType.SelectedValue)
					+ " Order By comm_desc "
					;
				Utility_Function.DDLBind(ddl,sql,"comm_desc","comm_id","--Select commodity--","0",comid);
				if (ddl.Items.Count > 1) 
				{
					ddl.SelectedIndex = 1;
				}
			}
		}
		private void setDDlCommo(DropDownList ddl,string comid)
		{
			if (comid.Trim() == "")
				comid = "0";
			//SQL0010
			sql = " Select cm.comm_id, cm.comm_desc "
					+ " From CS_Commodity cm, CS_Customer c "
					+ " Where cm.cust_code = c.cust_code "
					+ " And cm.status = 'Y' "
					+ " And cm.cust_code = " + MSSQL_Function.Sql_ConvText(this.txtCustcode.Text.Trim())
					+ " UNION "
					+ " Select cm.comm_id, cm.comm_desc "
					+ " From CS_Commodity cm, CS_Finish_Goods fg "
					+ " Where cm.comm_id = fg.out_comm_id "
					+ " And fg.out_no = " + MSSQL_Function.Sql_ConvText(this.txtDONo.Text.Trim())
					+ " And '1' = " + MSSQL_Function.Sql_ConvText(this.rdbType.SelectedValue)
					+ " UNION "
					+ " Select cm.comm_id, cm.comm_desc "
					+ " From CS_Commodity cm, CS_Mother_Coil mc "
					+ " Where cm.comm_id = mc.out_comm_id "
					+ " And mc.do_no = " + MSSQL_Function.Sql_ConvText(this.txtDONo.Text.Trim())
					+ " And '2' = " + MSSQL_Function.Sql_ConvText(this.rdbType.SelectedValue)
					+ " Order By comm_desc "
					;
			Utility_Function.DDLBind(ddl,sql,"comm_desc","comm_id","--Select commodity--","0",comid);
		}

		private void SetCheckCustPO(bool ch)
		{
			if (ch) 
			{
				//string order = this.txtOrderNo.Text.Trim();
				string contractno = this.txtContractNo.Text.Trim();

				if (contractno != "")
				{
					//SQL007
					sql = " cpo.cancel_flag is null " +
						" And cpo.cust_code = '" + this.txtCustcode.Text.Trim() +//@p_cust_code
						"' And cpo.cpo_no = '" +  contractno + "'";//@p_order_no
					string condi = Utility_Function.GetValueDB("CASE WHEN count(*)=0 THEN 'DENY' ELSE 'ALLOW' END ", 
									"CS_Customer_PO cpo",sql).ToString();
					if (condi =="DENY")
					{
						HidWarning.Value = " Customer P/O ó";
						setButton(false,false);
						GUI_Function.SetFocus(this.txtContractNo);
					}
					else
					{
						setButton(true,false);
						this.SetfocusGrid(0);
					}
				}
				else
				{
					setClearCust();
					HidWarning.Value = " Contract No. ó١ͧ.";
					GUI_Function.SetFocus(this.txtContractNo);
				}//if (order != "")
			
			}//if (ch) 
			else
				setButton(true,false);
		}

		private void QueryCustCode()
		{
			CTSQL ct = new CTSQL();
			sqlconn.Open();
			string custcode = this.txtCustcode.Text ;
			SqlDataReader r = ct.Get_Customer (this.txtCustcode.Text  , sqlconn);
			if(r.Read())
			{//cust_name, Customer P/O, address1, address2, Term
				this.txtCustcode.Text = r["cust_code"].ToString();
				this.lblCustName.Text = r["cust_name"].ToString();
				string cpo = Utility_Function.chkDBNull( r["cpo_flag"].ToString());
				if (cpo.ToUpper() == "Y")
					this.chCustPO.Checked = true;
				else
					this.chCustPO.Checked = false;
				this.lbAddress1.Text  = r["address1"].ToString();
				this.lbAddress2.Text  = r["address2"].ToString();
				this.txtTerm.Text   = r["credit"].ToString();
				CalDueDate(false);
				SetCheckCustPO(this.chCustPO.Checked);
				this.WarningLbl.Text = "";
				SetfocusGrid(0);
			}
			else
			{
				setClearCust();
				this.HidWarning.Value = "辺 Cust code "+ custcode;
				setButton(true,false);
				GUI_Function.SetFocus(this.txtCustcode );
			}
			sqlconn.Close(); 
			BindGrid(true);
		}

		#endregion

		#region Extra funtion
		private void SetfocusGrid(int row)
		{
			try
			{
				TextBox P_MNo = new TextBox();
				P_MNo = (TextBox) dgPacklist.Items[row].Cells[(int) myDGColumn.P_MNo].Controls[1];
//				RegisterStartupScript("focus", "<script language='JavaScript'>" +
//					" Form1." + P_MNo.ClientID + ".focus(); " +
//					" Form1." + P_MNo.ClientID + ".select(); " +
//					"<" + "/script>");
				SetDataGridItemFocus(P_MNo);
			}
			catch
			{}
		}
		
		private void SetDataGridItemFocus(System.Web.UI.Control Control)
		{
			string vScript  = 
				"<SCRIPT language='javascript'>document.getElementById(\'" + Control.ClientID + "\').focus()</SCRIPT>";
			Control.Page.RegisterStartupScript("Focus", vScript);
		}

		private void setButton(bool btSave,bool btUpdate)
		{
			this.btnSave.Enabled = btSave;
			this.btnUpdate.Enabled = btUpdate;
		}

		private void CalDueDate(bool setfocus)
		{
			try
			{
				string term = this.txtTerm.Text.Trim();
				this.txtDueDate.Text = "";
				if (this.DPIDate.DateText == "")
				{
					this.HidWarning.Value = " D/O Date ó.";
					GUI_Function.UC_SetFocus(this.DPIDate, "DateTbx");
				}
				else if (term == "")
				{
					this.HidWarning.Value = " Term(days) ó.";
					if (setfocus)
						GUI_Function.SetFocus(this.txtTerm);
				}
				else
				{
					CultureInfo culture = new CultureInfo("fr-FR", true);
					DateTime doDate = DateTime.Parse(this.DPIDate.DateText,culture);
					this.txtDueDate.Text = doDate.AddDays(Convert.ToInt64(term)).ToString("dd/MM/yyyy");
					if (setfocus)
						GUI_Function.SetFocus(this.txtCustcode);
 
				}
			}
			catch 
			{
				this.HidWarning.Value = "Term ͧ繵Ţҹ";	
				this.txtTerm.Text = "0";
				GUI_Function.SetFocus(this.txtTerm);
				this.txtDueDate.Text = this.DPIDate.DateText;

			}
		}
		#endregion

		#region Logout

		private void Logout_Btn_Click(object sender, System.EventArgs e)
		{
			Session["LoggedIn"] = "no";
			Session["username"] = "";
			Session.Clear();
			FormsAuthentication.SignOut();
			Response.Write("<script>parent.window.location.replace(\"../LoginForm.aspx\");</script>");

		}
		#endregion

		#region Action Button

		private void btnClear_Click(object sender, System.EventArgs e)
		{
			SetClearPage(false);
			this.UnLockLocation();
		}
		
		private void btnSave_Click(object sender, System.EventArgs e)
		{
			sqlconn.Open();
			if (Utility_Function.CheckReportLock(this.sqlconn, this.DPIDate.DateText)) 
			{
				this.HidWarning.Value = "ERROR_DATALOCKED";
				sqlconn.Close();
				return;
			}
			else { sqlconn.Close(); }

			if (Checkdata_Pack_Math())
				InsertDB();
		}
		private void btnUpdate_Click(object sender, System.EventArgs e)
		{
			sqlconn.Open();
			if (Utility_Function.CheckReportLock(this.sqlconn, this.DPIDate.DateText)) 
			{
				this.HidWarning.Value = "ERROR_DATALOCKED";
				sqlconn.Close();
				return;
			}
			else { sqlconn.Close(); }

			if (Checkdata_Pack_Math())
				UpdateDB();
		}

		#endregion

		#region Action textbox 

		private void txtCustcode_TextChanged(object sender, System.EventArgs e)
		{
			GUI_Function.LockLocation(this, "LOCATION_DETAIL");
			QueryCustCode();//There is setfocustgrid.
		//	Session["bindgrid"]= "N";
		}

		private void txtGrossWeight_TextChanged(object sender, System.EventArgs e)
		{	
			Session["bindgrid"]= "N";
			try
			{
				GUI_Function.LockLocation(this, "");
				if (this.txtGrossWeight.Text.IndexOf(".") != -1 || this.txtGrossWeight.Text.IndexOf("-") != -1
					|| this.txtGrossWeight.Text == "0")
				{
						this.HidWarning.Value = "Gross Weight ͧ繨ӹǹ Դź ٹ";
						GUI_Function.SetFocus(this.txtGrossWeight);
				}
				else if (Double.Parse(this.txtGrossWeight.Text) < Double.Parse(this.lblWeight.Text))
				{
					this.HidWarning.Value = "Gross Weight ͧҡҡѺ Net Weight";	
					this.txtGrossWeight.Text= this.lblWeight.Text;
					GUI_Function.SetFocus(this.txtGrossWeight);

				}
				else
					GUI_Function.SetFocus(this.txtRemark);
			}
			catch
			{
				this.HidWarning.Value = "Gross Weight ͧ繵Ţҹ";	
				this.txtGrossWeight.Text = this.lblWeight.Text;
				GUI_Function.SetFocus(this.txtGrossWeight);

			}
		}

		private void txtDONo_TextChanged(object sender, System.EventArgs e)
		{
			GUI_Function.LockLocation(this, "");
			QueryDONo();
			Session["bindgrid"]= "N";
		}
	
		private void Hidch_ServerChange(object sender, System.EventArgs e)
		{
			if (Hidch.Value == "change")
			{
				BindGrid(false);
				Hidch.Value= "";
			}

		}
		#endregion

		#region Action Date

//		private void DPIDate_onHideCalendar(object sender, System.EventArgs e) 
//		{
//			if (Utility_Function.chkDBNull(Session["date"]) != this.DPIDate.DateText)
//			{
//				this.BindGrid(true);
//				CalDueDate(false);
//			}
//		}
//
//		private void DPIDate_onShowCalendar(object sender, System.EventArgs e) 
//		{
//			Session["date"] = this.DPIDate.DateText;
//		}
		
		private void DPIDate_DateChanged(object sender, EventArgs e)
		{
			this.BindGrid(true);
			CalDueDate(false);
			if (this.DPIDate.WarningText == "")
				GUI_Function.SetFocus(this.txtContractNo);
		}

		#endregion

		#region Action Radio Button or Check box

		private void rdbType_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			SetClearPage(false);
		}
		private void chConsign_CheckedChanged(object sender, System.EventArgs e)
		{
			this.BindGrid(true);
			if (this.txtContractNo.Text.Trim() == "")
				GUI_Function.SetFocus(this.txtContractNo);
			else if(this.txtCustcode.Text.Trim() == "")
				GUI_Function.SetFocus(this.txtCustcode);
			else
				this.SetfocusGrid(0);
		
		}
		#endregion

		#region Datagrid
		
		private void dgPacklist_ItemDataBound(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
		{
			string strQty;
			string strWt;
			if ( e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
			{
				TextBox pn = (TextBox) e.Item.Cells[(int) myDGColumn.P_MNo].Controls[1];
				pn.Attributes.Add("onkeyup", "CheckKeyPress('" + Hidch.ClientID +"')");
				TextBox qty = (TextBox) e.Item.Cells[(int) myDGColumn.Qty].Controls[1];
				TextBox wt = (TextBox) e.Item.Cells[(int) myDGColumn.Weight].Controls[1];
				if ( qty.Text.Trim() == "" ) 
					strQty = "0";
				else
					strQty = qty.Text.Trim();

				if ( wt.Text.Trim() == "" ) 
					strWt = "0";
				else
					strWt = wt.Text.Trim();
				
				TotalQty = Double.Parse(this.lblQty.Text);
				TotalQty += Double.Parse(strQty);
				this.lblQty.Text = TotalQty.ToString();  

				TotalWt =Double.Parse(this.lblWeight.Text);
				TotalWt += Double.Parse(strWt);
				this.lblWeight.Text = TotalWt.ToString();
				
//				DropDownList ddl = (DropDownList) e.Item.Cells[(int) myDGColumn.commo].Controls[1];
//				string comid =  e.Item.Cells[(int) myDGColumn.commoid].Text.Trim();
//				this.setDDlCommo(ddl,comid);
			}
			else if( e.Item.ItemType == ListItemType.Footer)
			{
				((Label) e.Item.Cells[(int) myDGColumn.Qty].Controls[1]).Text = string.Format("{0:n}",TotalQty);
				((Label) e.Item.Cells[(int) myDGColumn.Weight].Controls[1]).Text = string.Format("{0:n}", TotalWt);
				this.txtNetWeight.Text = TotalWt.ToString();
			}
		}

		#endregion

		#region Check data
		private bool Checkdata_Pack_Math()
		{
			string err = "";
//			for (int i=0; i< this.ddlNo.Items.Count; i++)
//			{
//				DataTable dt = new DataTable();
//				dt = (DataTable)Session["dt"];
//				DataView dv = dt.DefaultView;
//				dv.RowFilter = "pack_no='" + ddlNo.Items[i].Value + "'";
//				if (dv.Count < 1)
//					err = err + ddlNo.Items[i].Value + " ";
//			}
			// Ammer Update 02/03/2006
//			for (int i=0; i< this.ddlNo.Items.Count; i++)
//			{
//				bool same = false;
//				for (int j=0; j<MAX_DATAGRID_ROW; j++)
//				{
//					TextBox P_MNo = new TextBox();
//					P_MNo = (TextBox) dgPacklist.Items[j].Cells[(int) myDGColumn.P_MNo].Controls[1];
//					if (P_MNo.Text== ddlNo.Items[i].Value)
//						same = true;
//				}
//				if (!same)
//					err = err + ddlNo.Items[i].Value + " ";
//			}
//			if (err != "")
//				err = "Ҵ Pack/Math No " + err + "\n";
			// Ammer Updated

			ArrayList PMnoList = new ArrayList();
			for (int i=0; i<MAX_DATAGRID_ROW; i++)
			{
				TextBox P_MNo = new TextBox();
				P_MNo = (TextBox) dgPacklist.Items[i].Cells[(int) myDGColumn.P_MNo].Controls[1];
				DropDownList ddl = (DropDownList) dgPacklist.Items[i].Cells[(int) myDGColumn.commo].Controls[1];
				string comid = ddl.SelectedValue;
				if (comid == "0" & P_MNo.Text.Trim() != "")
					err = err + "س͡ commodity ͧ Pack/Math No " + P_MNo.Text + "\n";
				if (P_MNo.Text.Trim() != "")
				{
					if (PMnoList.IndexOf(P_MNo.Text) == -1) 
						PMnoList.Add(P_MNo.Text);
					else 
						err = err + "͡ Pack/Math No  [" + P_MNo.Text + "]\n";
				}
			}
			if (this.txtGrossWeight.Text.Trim() == "")
			{
				err = err + "س Gross Weight \n";
				GUI_Function.SetFocus(this.txtGrossWeight);	
			}
			if (this.txtCustcode.Text.Trim() == "")
			{
				err = err + "س Cust Code \n";
				GUI_Function.SetFocus(this.txtCustcode);	
			}
			try
			{
				if (Double.Parse(this.txtGrossWeight.Text) < Double.Parse(this.lblWeight.Text))
				{
					err = err + "Gross Weight ͧҡҡѺ Net Weight \n";	
					this.txtGrossWeight.Text= this.lblWeight.Text;
					GUI_Function.SetFocus(this.txtGrossWeight);

				}
			}
			catch
			{
				err = err + "Gross Weight ͧ繵Ţҹ \n";	
				this.txtGrossWeight.Text = this.lblWeight.Text;
				GUI_Function.SetFocus(this.txtGrossWeight);

			}

			if (this.txtContractNo.Text.Trim() == "")
			{
				err = err + "س ContractNo ";
				GUI_Function.SetFocus(this.txtContractNo);	
			}
			if (this.txtOrderNo.Text.Trim() == "")
			{
				err = err + "س OrderNo ";
				GUI_Function.SetFocus(this.txtOrderNo);	
			}
			if (err == "")
				return true;
			else
			{
				this.HidWarning.Value =  err;	
				return false;
			}
		}

		#endregion

		#region Search D/O No
		private void QueryDONo()
		{
			//SQL001
			sql = "Select d.do_no, convert(varchar(10),d.do_date,20) do_date " +
				  " , d.contract_no, d.order_no, c.credit term, convert(varchar(10),d.due_date,20) due_date " +
				  " , d.consign_flag, d.cust_code, c.cust_name, c.address1, c.address2, c.cpo_flag " +
				  " , d.net_wt, d.gross_wt, d.remarks From CS_Do d, CS_Customer c " +
				  " Where d.cust_code = c.cust_code And d.cancel_flag IS NULL " +
				  " And d.do_type = " + this.rdbType.SelectedValue + //@p_do_type
				  " And d.do_no ='" + this.txtDONo.Text + "'"; // @p_do_no
			DataTable dt = Utility_Function.loadDb(sql);
			if(dt.Rows.Count > 0)
			{
				this.txtDONo.Text  = dt.Rows[0]["do_no"].ToString();
				this.DPIDate.DateText =Date_Function.ConvertDate_Dash2Slash(dt.Rows[0]["do_date"].ToString());
				this.txtDueDate.Text =Date_Function.ConvertDate_Dash2Slash(dt.Rows[0]["due_date"].ToString());
				this.txtContractNo.Text =dt.Rows[0]["contract_no"].ToString();
				this.txtOrderNo.Text =dt.Rows[0]["order_no"].ToString();
				this.txtTerm.Text =dt.Rows[0]["term"].ToString();
				this.lblCustName.Text =dt.Rows[0]["cust_name"].ToString();
				this.txtCustcode.Text =dt.Rows[0]["cust_code"].ToString();
				this.lbAddress1.Text = dt.Rows[0]["address1"].ToString ();
				this.lbAddress2.Text= dt.Rows[0]["address2"].ToString ();
				string cpo = Utility_Function.chkDBNull( dt.Rows[0]["cpo_flag"].ToString());
				if (cpo.ToUpper() == "Y")
					this.chCustPO.Checked = true;
				else
					this.chCustPO.Checked = false;
				string consign = Utility_Function.chkDBNull( dt.Rows[0]["consign_flag"].ToString());
				if (consign == "*")
					this.chConsign.Checked = true;
				else
					this.chConsign.Checked = false;

				this.txtNetWeight.Text = dt.Rows[0]["net_wt"].ToString ();
				this.txtGrossWeight.Text = dt.Rows[0]["gross_wt"].ToString ();
				this.txtRemark.Text = dt.Rows[0]["remarks"].ToString ();

				this.WarningLbl.Text = "";
				setToUpdate(false);
				setButton(false,true);
				this.BindDataGrideForUpdate();
				CheckCanUpdate();

				sqlconn.Open();
				if (Utility_Function.CheckReportLock(this.sqlconn, this.DPIDate.DateText)) 
				{
					this.HidWarning.Value = "ERROR_DATALOCKED";
				}
				sqlconn.Close();
			}
			else
			{
				this.HidWarning.Value="辺 D/O No" + this.txtDONo.Text;
				this.SetClearPage(false); 
				setToUpdate(true);
				setButton(true,false);
				GUI_Function.SetFocus(this.txtDONo);
			}
		}
		private void setToUpdate(bool enable)
		{
			this.DPIDate.Enabled =  enable;
			//this.txtDONo.Enabled = enable;
			this.txtContractNo.Enabled  = enable;
			this.txtOrderNo.Enabled =enable;
			this.txtCustcode.Enabled = enable;
			this.chConsign.Enabled= enable;
		}

		private void BindDataGrideForUpdate()
		{
			this.lblWeight.Text = "0";
			this.lblQty.Text = "0";
			string sql;
			//SQL002
			//sql = "Select di.do_no, di.item, di.pack_no, m.mat_spec, di.size, di.do_qty qty, di.do_wt wt " +
				sql = "Select di.item No, di.pack_no, m.mat_spec, di.size, di.do_qty qty, di.do_wt wt " +
				", A.wh_code, A.detail1, A.comm_id From CS_DO_Item di, CS_Material m, ( " +
				" Select 1 do_type, pack_no pack_no, wh_code, part_code detail1, out_comm_id comm_id From CS_Finish_Goods " +
				" Where out_no='" + this.txtDONo.Text.Trim() + "'" + //@p_do_no
				" UNION " +
				" Select 2 do_type, mat_no pack_no, wh_code, mat_code detail1, out_comm_id comm_id From CS_Mother_Coil " +
				" Where do_no='" + this.txtDONo.Text.Trim() + "'" + //@p_do_no
				" ) A Where di.mat_code = m.mat_code And di.cancel_flag IS NULL " +
				" And di.pack_no = A.pack_no And A.do_type = " + this.rdbType.SelectedValue + //@p_do_type
				" And di.do_no ='" + this.txtDONo.Text.Trim() + "'" + // @p_do_no
				" Order By di.item ";

			DataTable dt = Utility_Function.loadDb(sql);
			int position = dt.Rows.Count;
			DataRow dr;
			for (int i = 0; i < MAX_DATAGRID_ROW; i++)
			{
				if (i > dt.Rows.Count-1 )
				{
					dr = dt.NewRow();
					dr["No"] = i + 1;
					dr["comm_id"]= 0;
					dt.Rows.Add (dr);
				}
				else
					dt.Rows[i]["No"] = i+1;
			}
			Session["dt"]= dt; 
			ShowDetail(dt);
			dgPacklist.DataSource = dt.DefaultView;
			dgPacklist.DataBind();
			
			if (position == MAX_DATAGRID_ROW)
				GUI_Function.SetFocus(this.txtGrossWeight);
			else
				this.SetfocusGrid(position);
			SetGridEnable();
			this.ReadCommodity();
		}

		private void SetGridEnable()
		{
			lblNo.Text =  "-1";

			for (int i = 0; i < MAX_DATAGRID_ROW; i++)
			{
				TextBox P_MNo = new TextBox();
				P_MNo = (TextBox) dgPacklist.Items[i].Cells[(int) myDGColumn.P_MNo].Controls[1];
				DropDownList ddl = (DropDownList) dgPacklist.Items[i].Cells[(int) myDGColumn.commo].Controls[1];
				this.setDDlCommo(ddl, dgPacklist.Items[i].Cells[(int) myDGColumn.commoid].Text);

				if (P_MNo.Text.Trim() != "")
				{
					P_MNo.ReadOnly = true;
					ddl.Enabled = false;
				}
				else
				{
					if (lblNo.Text ==  "-1")
					{
						lblNo.Text = i.ToString();
					}
					P_MNo.ReadOnly = false;
					ddl.Enabled = true;
				}
			}//for
			if (lblNo.Text ==  "-1")
				lblNo.Text =  MAX_DATAGRID_ROW.ToString();

		}
		private void CheckCanUpdate()
		{
			//SQL009
			sql = "d.do_flag IS NULL And d.inv_flag IS NULL " +
				  " And d.pkl_inv_no IS NULL And d.do_no = '" + this.txtDONo.Text.Trim() + "'" + //@p_do_no
				  " And d.do_type = " + this.rdbType.SelectedValue ; //@p_do_type
			string condi = Utility_Function.GetValueDB("CASE WHEN count(*)=0 THEN 'DENY' ELSE 'ALLOW' END ", 
							"CS_Do d",sql).ToString();
			if (condi =="DENY")
				setButton(false,false);
			else
				setButton(false,true);

		}
		#endregion

		#region Transaction

		private bool InsertDB()
		{
			try
			{
				sqlconn.Open();
				SqlCommand cmd = sqlconn.CreateCommand();
				cmd.CommandText = "CSFZ08_1_PROC001";
				cmd.CommandType = CommandType.StoredProcedure;
				cmd.Parameters.Add (new SqlParameter("@p_do_type", this.rdbType.SelectedValue.ToString() ));
				cmd.Parameters.Add (new SqlParameter("@p_do_date", Date_Function.ConvertDate_Slash2Dash(this.DPIDate.DateText)));
				cmd.Parameters.Add (new SqlParameter("@p_contract_no", this.txtContractNo.Text));
				cmd.Parameters.Add (new SqlParameter("@p_order_no", this.txtOrderNo.Text));
				cmd.Parameters.Add (new SqlParameter("@p_due_date", Date_Function.ConvertDate_Slash2Dash(this.txtDueDate.Text)));
				if (this.chConsign.Checked)
					cmd.Parameters.Add (new SqlParameter("@p_consign_flag", "*"));
				else
					cmd.Parameters.Add (new SqlParameter("@p_consign_flag", DBNull.Value));
				cmd.Parameters.Add (new SqlParameter("@p_cust_code", this.txtCustcode.Text));

				int i;
				for (i=0; i<MAX_DATAGRID_ROW; i++)
				{
					TextBox P_MNo = new TextBox();
					P_MNo = (TextBox) dgPacklist.Items[i].Cells[(int) myDGColumn.P_MNo].Controls[1];
					string s;
					s =Utility_Function.chkDBNull(P_MNo.Text.Trim());
					if (s=="")
						cmd.Parameters.Add (new SqlParameter("@p_pack_no_"+ string.Format("{0:0#}",i+1), DBNull.Value));
					else
						cmd.Parameters.Add (new SqlParameter("@p_pack_no_"+ string.Format("{0:0#}",i+1), s));
					if (P_MNo.Text.Trim() != "")
					{
						DropDownList ddl = (DropDownList) dgPacklist.Items[i].Cells[(int) myDGColumn.commo].Controls[1];
						string comid = ddl.SelectedValue.ToString();
						cmd.Parameters.Add (new SqlParameter("@p_comm_id_"+ string.Format("{0:0#}",i+1), comid));
					}
					else
						cmd.Parameters.Add (new SqlParameter("@p_comm_id_"+ string.Format("{0:0#}",i+1), DBNull.Value));

				}
				cmd.Parameters.Add (new SqlParameter("@p_net_wt", this.lblWeight.Text));
				cmd.Parameters.Add (new SqlParameter("@p_gross_wt", this.txtGrossWeight.Text));
				cmd.Parameters.Add (new SqlParameter("@p_remark", this.txtRemark.Text));
				cmd.Parameters.Add (new SqlParameter("@p_user_id", Session["username"].ToString()));
				SqlParameter sampParm = cmd.Parameters.Add("@out_do_no", SqlDbType.VarChar,255);
				sampParm.Direction = ParameterDirection.Output;

				object o = cmd.ExecuteScalar();
				this.txtDONo.Text = sampParm.Value.ToString();
				sqlconn.Close();
				QueryDONo();
				Session["bindgrid"]= "N";
				this.HidWarning.Value="SAVEBTN_COMPLETE";
				return true;
			}
			catch (SqlException e) 
			{
				string errorMessages = "";

				for (int i=0; i < e.Errors.Count; i++)
				{
					errorMessages += "Message: " + e.Errors[i].Message + "\n" ;
				}
				HidWarning.Value=errorMessages;
				return false;
			}

		}
		private bool UpdateDB()
		{
			try
			{
				sqlconn.Open();
				SqlCommand cmd = sqlconn.CreateCommand();
				cmd.CommandText = "CSFZ08_1_PROC002";
				cmd.CommandType = CommandType.StoredProcedure;
				cmd.Parameters.Add (new SqlParameter("@p_do_type", this.rdbType.SelectedValue.ToString() ));
				cmd.Parameters.Add (new SqlParameter("@p_do_no", this.txtDONo.Text ));
				cmd.Parameters.Add (new SqlParameter("@p_do_date", Date_Function.ConvertDate_Slash2Dash(this.DPIDate.DateText)));
				cmd.Parameters.Add (new SqlParameter("@p_contract_no", this.txtContractNo.Text));
				cmd.Parameters.Add (new SqlParameter("@p_order_no", this.txtOrderNo.Text));
				cmd.Parameters.Add (new SqlParameter("@p_due_date", Date_Function.ConvertDate_Slash2Dash(this.txtDueDate.Text)));
				if (this.chConsign.Checked)
					cmd.Parameters.Add (new SqlParameter("@p_consign_flag", "*"));
				else
					cmd.Parameters.Add (new SqlParameter("@p_consign_flag", DBNull.Value));
				cmd.Parameters.Add (new SqlParameter("@p_cust_code", this.txtCustcode.Text));

				int i;
				for (i=0; i<MAX_DATAGRID_ROW; i++)
				{
					for (i=0; i<MAX_DATAGRID_ROW; i++)
					{
						string s,comid;
						TextBox P_MNo = new TextBox();
						P_MNo = (TextBox) dgPacklist.Items[i].Cells[(int) myDGColumn.P_MNo].Controls[1];
						if (i >= Convert.ToInt64(lblNo.Text))
						{
							s =Utility_Function.chkDBNull(P_MNo.Text.Trim());
							if (s=="")
								cmd.Parameters.Add (new SqlParameter("@p_pack_no_"+ string.Format("{0:0#}",i+1), DBNull.Value));
							else
								cmd.Parameters.Add (new SqlParameter("@p_pack_no_"+ string.Format("{0:0#}",i+1), s));
							DropDownList ddl = (DropDownList) dgPacklist.Items[i].Cells[(int) myDGColumn.commo].Controls[1];
							comid = ddl.SelectedValue.ToString();
							cmd.Parameters.Add (new SqlParameter("@p_comm_id_"+ string.Format("{0:0#}",i+1), comid));

						}
						else
						{
							cmd.Parameters.Add (new SqlParameter("@p_comm_id_"+ string.Format("{0:0#}",i+1), DBNull.Value));
							cmd.Parameters.Add (new SqlParameter("@p_pack_no_"+ string.Format("{0:0#}",i+1), DBNull.Value));
						}

					}			
				}
				cmd.Parameters.Add (new SqlParameter("@p_net_wt", this.lblWeight.Text));
				cmd.Parameters.Add (new SqlParameter("@p_gross_wt", this.txtGrossWeight.Text));
				cmd.Parameters.Add (new SqlParameter("@p_remark", this.txtRemark.Text));
				cmd.Parameters.Add (new SqlParameter("@p_user_id", Session["username"].ToString()));
				cmd.ExecuteNonQuery();
				sqlconn.Close();
				QueryDONo();
				this.HidWarning.Value="SAVEBTN_COMPLETE";
				Session["bindgrid"]= "N";
				return true;
			}
			catch (SqlException e) 
			{
				string errorMessages = "";

				for (int i=0; i < e.Errors.Count; i++)
				{
					errorMessages += "Message: " + e.Errors[i].Message + "\n" ;
				}
				HidWarning.Value=errorMessages;
				return false;
			}
				}
		#endregion

		private void txtContractNo_TextChanged(object sender, System.EventArgs e)
		{
			//GUI_Function.LockLocation(this, "");
			if (this.txtCustcode.Text.Trim() != "")
				QueryCustCode();
			else
				GUI_Function.SetFocus(this.txtOrderNo);
		}

		private void btnPrint_Click(object sender, System.EventArgs e)
		{
			string user, password, server, database;
			user = System.Configuration.ConfigurationSettings.AppSettings["User"].ToString();
			password = System.Configuration.ConfigurationSettings.AppSettings["Password"].ToString();
			server = System.Configuration.ConfigurationSettings.AppSettings["Server"].ToString();
			database = System.Configuration.ConfigurationSettings.AppSettings["Database"].ToString();

			string[] param = new string[2];
			param[0] = this.txtDONo.Text.Trim();
			param[1] = this.txtDONo.Text.Trim();
			GeneratePDF.generate_pdf Rpt = new GeneratePDF.generate_pdf(server,database,user,password);
			if (this.rdbType.SelectedIndex == 0)	//--F/G
				Rpt.CreateReport("CSP08_2L_12L.rpt",param,"PDF");
			else	// M/C
				Rpt.CreateReport("CSP08C_2L_12L.rpt",param,"PDF");
		}

		#region AutoSet CommoDdl Patch
		// For auto set commo ddl to the same as first ddl
		private void dgPacklist_ItemCreated(object sender, System.Web.UI.WebControls.DataGridItemEventArgs e)
		{
			if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem) 
			{
				DropDownList CommoDdl = (DropDownList) e.Item.FindControl("ddlCommo");
				CommoDdl.SelectedIndexChanged += new System.EventHandler(this.CommoDdl_SelectedIndexChanged);
			}
		}

		private void CommoDdl_SelectedIndexChanged(object sender, System.EventArgs e) 
		{
			DropDownList CommoDdl = (DropDownList)sender;
			// get current row
			DataGridItem DgridRow = (DataGridItem)CommoDdl.Parent.Parent;
			int RowNo = DgridRow.ItemIndex;
			int SetIndex = CommoDdl.SelectedIndex;
			int i = 0;

			// Set below Ddl selectedindex to the same
			for (i = RowNo; i < MAX_DATAGRID_ROW; i++)
			{
				DropDownList ddl = (DropDownList) dgPacklist.Items[i].Cells[(int) myDGColumn.commo].Controls[1];
				ddl.SelectedIndex = SetIndex;
			}
		}
		#endregion

	}//end class
}
